/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.TokenPruningConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TextExpansionQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final String modelId;
    private final String modelText;
    @Nullable
    private final TokenPruningConfig pruningConfig;
    public static final JsonpDeserializer<TextExpansionQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextExpansionQuery::setupTextExpansionQueryDeserializer);

    private TextExpansionQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.modelText = ApiTypeHelper.requireNonNull(builder.modelText, this, "modelText");
        this.pruningConfig = builder.pruningConfig;
    }

    public static TextExpansionQuery of(Function<Builder, ObjectBuilder<TextExpansionQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.TextExpansion;
    }

    public final String field() {
        return this.field;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String modelText() {
        return this.modelText;
    }

    @Nullable
    public final TokenPruningConfig pruningConfig() {
        return this.pruningConfig;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("model_text");
        generator.write(this.modelText);
        if (this.pruningConfig != null) {
            generator.writeKey("pruning_config");
            this.pruningConfig.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupTextExpansionQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::modelText, JsonpDeserializer.stringDeserializer(), "model_text");
        op.add(Builder::pruningConfig, TokenPruningConfig._DESERIALIZER, "pruning_config");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TextExpansionQuery> {
        private String field;
        private String modelId;
        private String modelText;
        @Nullable
        private TokenPruningConfig pruningConfig;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder modelText(String value) {
            this.modelText = value;
            return this;
        }

        public final Builder pruningConfig(@Nullable TokenPruningConfig value) {
            this.pruningConfig = value;
            return this;
        }

        public final Builder pruningConfig(Function<TokenPruningConfig.Builder, ObjectBuilder<TokenPruningConfig>> fn) {
            return this.pruningConfig(fn.apply(new TokenPruningConfig.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextExpansionQuery build() {
            this._checkSingleUse();
            return new TextExpansionQuery(this);
        }
    }
}

