/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PutCalendarResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutCalendarRequest
extends RequestBase
implements JsonpSerializable {
    private final String calendarId;
    @Nullable
    private final String description;
    private final List<String> jobIds;
    public static final JsonpDeserializer<PutCalendarRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutCalendarRequest::setupPutCalendarRequestDeserializer);
    public static final Endpoint<PutCalendarRequest, PutCalendarResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutCalendarRequest, PutCalendarResponse>("es/ml.put_calendar", request -> "PUT", request -> {
        boolean _calendarId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.calendarId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _calendarId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("calendarId", request.calendarId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutCalendarResponse._DESERIALIZER);

    private PutCalendarRequest(Builder builder) {
        this.calendarId = ApiTypeHelper.requireNonNull(builder.calendarId, this, "calendarId");
        this.description = builder.description;
        this.jobIds = ApiTypeHelper.unmodifiable(builder.jobIds);
    }

    public static PutCalendarRequest of(Function<Builder, ObjectBuilder<PutCalendarRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String calendarId() {
        return this.calendarId;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final List<String> jobIds() {
        return this.jobIds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.jobIds)) {
            generator.writeKey("job_ids");
            generator.writeStartArray();
            for (String item0 : this.jobIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutCalendarRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::jobIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "job_ids");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutCalendarRequest> {
        private String calendarId;
        @Nullable
        private String description;
        @Nullable
        private List<String> jobIds;

        public final Builder calendarId(String value) {
            this.calendarId = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder jobIds(List<String> list) {
            this.jobIds = Builder._listAddAll(this.jobIds, list);
            return this;
        }

        public final Builder jobIds(String value, String ... values) {
            this.jobIds = Builder._listAdd(this.jobIds, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutCalendarRequest build() {
            this._checkSingleUse();
            return new PutCalendarRequest(this);
        }
    }
}

