/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.HttpInputRequestResult;
import co.elastic.clients.elasticsearch.watcher.HttpInputResponseResult;
import co.elastic.clients.elasticsearch.watcher.PagerDutyEvent;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PagerDutyResult
implements JsonpSerializable {
    private final PagerDutyEvent event;
    @Nullable
    private final String reason;
    @Nullable
    private final HttpInputRequestResult request;
    @Nullable
    private final HttpInputResponseResult response;
    public static final JsonpDeserializer<PagerDutyResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PagerDutyResult::setupPagerDutyResultDeserializer);

    private PagerDutyResult(Builder builder) {
        this.event = ApiTypeHelper.requireNonNull(builder.event, this, "event");
        this.reason = builder.reason;
        this.request = builder.request;
        this.response = builder.response;
    }

    public static PagerDutyResult of(Function<Builder, ObjectBuilder<PagerDutyResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final PagerDutyEvent event() {
        return this.event;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    @Nullable
    public final HttpInputRequestResult request() {
        return this.request;
    }

    @Nullable
    public final HttpInputResponseResult response() {
        return this.response;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("event");
        this.event.serialize(generator, mapper);
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        if (this.request != null) {
            generator.writeKey("request");
            this.request.serialize(generator, mapper);
        }
        if (this.response != null) {
            generator.writeKey("response");
            this.response.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPagerDutyResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::event, PagerDutyEvent._DESERIALIZER, "event");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::request, HttpInputRequestResult._DESERIALIZER, "request");
        op.add(Builder::response, HttpInputResponseResult._DESERIALIZER, "response");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PagerDutyResult> {
        private PagerDutyEvent event;
        @Nullable
        private String reason;
        @Nullable
        private HttpInputRequestResult request;
        @Nullable
        private HttpInputResponseResult response;

        public final Builder event(PagerDutyEvent value) {
            this.event = value;
            return this;
        }

        public final Builder event(Function<PagerDutyEvent.Builder, ObjectBuilder<PagerDutyEvent>> fn) {
            return this.event(fn.apply(new PagerDutyEvent.Builder()).build());
        }

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        public final Builder request(@Nullable HttpInputRequestResult value) {
            this.request = value;
            return this;
        }

        public final Builder request(Function<HttpInputRequestResult.Builder, ObjectBuilder<HttpInputRequestResult>> fn) {
            return this.request(fn.apply(new HttpInputRequestResult.Builder()).build());
        }

        public final Builder response(@Nullable HttpInputResponseResult value) {
            this.response = value;
            return this;
        }

        public final Builder response(Function<HttpInputResponseResult.Builder, ObjectBuilder<HttpInputResponseResult>> fn) {
            return this.response(fn.apply(new HttpInputResponseResult.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PagerDutyResult build() {
            this._checkSingleUse();
            return new PagerDutyResult(this);
        }
    }
}

