/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Input;
import co.elastic.clients.elasticsearch.watcher.InputVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ChainInput
implements InputVariant,
JsonpSerializable {
    private final List<NamedValue<Input>> inputs;
    public static final JsonpDeserializer<ChainInput> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChainInput::setupChainInputDeserializer);

    private ChainInput(Builder builder) {
        this.inputs = ApiTypeHelper.unmodifiableRequired(builder.inputs, (Object)this, "inputs");
    }

    public static ChainInput of(Function<Builder, ObjectBuilder<ChainInput>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Input.Kind _inputKind() {
        return Input.Kind.Chain;
    }

    public final List<NamedValue<Input>> inputs() {
        return this.inputs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.inputs)) {
            generator.writeKey("inputs");
            generator.writeStartArray();
            for (NamedValue<Input> item0 : this.inputs) {
                generator.writeStartObject();
                generator.writeKey(item0.name());
                item0.value().serialize(generator, mapper);
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupChainInputDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::inputs, JsonpDeserializer.arrayDeserializer(NamedValue.deserializer(() -> Input._DESERIALIZER)), "inputs");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ChainInput> {
        private List<NamedValue<Input>> inputs;

        public final Builder inputs(List<NamedValue<Input>> list) {
            this.inputs = Builder._listAddAll(this.inputs, list);
            return this;
        }

        @SafeVarargs
        public final Builder inputs(NamedValue<Input> value, NamedValue<Input> ... values) {
            this.inputs = Builder._listAdd(this.inputs, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ChainInput build() {
            this._checkSingleUse();
            return new ChainInput(this);
        }
    }
}

