/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.field_usage_stats;

import co.elastic.clients.elasticsearch.indices.field_usage_stats.ShardsStats;
import co.elastic.clients.elasticsearch.indices.stats.ShardRouting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class UsageStatsShards
implements JsonpSerializable {
    private final ShardRouting routing;
    private final ShardsStats stats;
    private final String trackingId;
    private final long trackingStartedAtMillis;
    public static final JsonpDeserializer<UsageStatsShards> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UsageStatsShards::setupUsageStatsShardsDeserializer);

    private UsageStatsShards(Builder builder) {
        this.routing = ApiTypeHelper.requireNonNull(builder.routing, this, "routing");
        this.stats = ApiTypeHelper.requireNonNull(builder.stats, this, "stats");
        this.trackingId = ApiTypeHelper.requireNonNull(builder.trackingId, this, "trackingId");
        this.trackingStartedAtMillis = ApiTypeHelper.requireNonNull(builder.trackingStartedAtMillis, (Object)this, "trackingStartedAtMillis", 0L);
    }

    public static UsageStatsShards of(Function<Builder, ObjectBuilder<UsageStatsShards>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardRouting routing() {
        return this.routing;
    }

    public final ShardsStats stats() {
        return this.stats;
    }

    public final String trackingId() {
        return this.trackingId;
    }

    public final long trackingStartedAtMillis() {
        return this.trackingStartedAtMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("routing");
        this.routing.serialize(generator, mapper);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
        generator.writeKey("tracking_id");
        generator.write(this.trackingId);
        generator.writeKey("tracking_started_at_millis");
        generator.write(this.trackingStartedAtMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupUsageStatsShardsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::routing, ShardRouting._DESERIALIZER, "routing");
        op.add(Builder::stats, ShardsStats._DESERIALIZER, "stats");
        op.add(Builder::trackingId, JsonpDeserializer.stringDeserializer(), "tracking_id");
        op.add(Builder::trackingStartedAtMillis, JsonpDeserializer.longDeserializer(), "tracking_started_at_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UsageStatsShards> {
        private ShardRouting routing;
        private ShardsStats stats;
        private String trackingId;
        private Long trackingStartedAtMillis;

        public final Builder routing(ShardRouting value) {
            this.routing = value;
            return this;
        }

        public final Builder routing(Function<ShardRouting.Builder, ObjectBuilder<ShardRouting>> fn) {
            return this.routing(fn.apply(new ShardRouting.Builder()).build());
        }

        public final Builder stats(ShardsStats value) {
            this.stats = value;
            return this;
        }

        public final Builder stats(Function<ShardsStats.Builder, ObjectBuilder<ShardsStats>> fn) {
            return this.stats(fn.apply(new ShardsStats.Builder()).build());
        }

        public final Builder trackingId(String value) {
            this.trackingId = value;
            return this;
        }

        public final Builder trackingStartedAtMillis(long value) {
            this.trackingStartedAtMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UsageStatsShards build() {
            this._checkSingleUse();
            return new UsageStatsShards(this);
        }
    }
}

