/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CustomNormalizer;
import co.elastic.clients.elasticsearch._types.analysis.LowercaseNormalizer;
import co.elastic.clients.elasticsearch._types.analysis.NormalizerVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Normalizer
implements TaggedUnion<Kind, NormalizerVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final NormalizerVariant _value;
    public static final JsonpDeserializer<Normalizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Normalizer::setupNormalizerDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final NormalizerVariant _get() {
        return this._value;
    }

    public Normalizer(NormalizerVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._normalizerKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Normalizer(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Normalizer of(Function<Builder, ObjectBuilder<Normalizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCustom() {
        return this._kind == Kind.Custom;
    }

    public CustomNormalizer custom() {
        return (CustomNormalizer)TaggedUnionUtils.get(this, Kind.Custom);
    }

    public boolean isLowercase() {
        return this._kind == Kind.Lowercase;
    }

    public LowercaseNormalizer lowercase() {
        return (LowercaseNormalizer)TaggedUnionUtils.get(this, Kind.Lowercase);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNormalizerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::custom, CustomNormalizer._DESERIALIZER, "custom");
        op.add(Builder::lowercase, LowercaseNormalizer._DESERIALIZER, "lowercase");
        op.setTypeProperty("type", "custom");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Normalizer> {
        private Kind _kind;
        private NormalizerVariant _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Normalizer> custom(CustomNormalizer v) {
            this._kind = Kind.Custom;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Normalizer> custom(Function<CustomNormalizer.Builder, ObjectBuilder<CustomNormalizer>> fn) {
            return this.custom(fn.apply(new CustomNormalizer.Builder()).build());
        }

        public ObjectBuilder<Normalizer> lowercase(LowercaseNormalizer v) {
            this._kind = Kind.Lowercase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Normalizer> lowercase(Function<LowercaseNormalizer.Builder, ObjectBuilder<LowercaseNormalizer>> fn) {
            return this.lowercase(fn.apply(new LowercaseNormalizer.Builder()).build());
        }

        @Override
        public Normalizer build() {
            this._checkSingleUse();
            return new Normalizer(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Custom("custom"),
        Lowercase("lowercase");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

