/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.query_role;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.security.RoleDescriptor;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryRole
extends RoleDescriptor {
    private final List<FieldValue> sort;
    private final String name;
    public static final JsonpDeserializer<QueryRole> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRole::setupQueryRoleDeserializer);

    private QueryRole(Builder builder) {
        super(builder);
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static QueryRole of(Function<Builder, ObjectBuilder<QueryRole>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FieldValue> sort() {
        return this.sort;
    }

    public final String name() {
        return this.name;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("_sort");
            generator.writeStartArray();
            for (FieldValue item0 : this.sort) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("name");
        generator.write(this.name);
    }

    protected static void setupQueryRoleDeserializer(ObjectDeserializer<Builder> op) {
        RoleDescriptor.setupRoleDescriptorDeserializer(op);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "_sort");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends RoleDescriptor.AbstractBuilder<Builder>
    implements ObjectBuilder<QueryRole> {
        @Nullable
        private List<FieldValue> sort;
        private String name;

        public final Builder sort(List<FieldValue> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(FieldValue value, FieldValue ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(String value, String ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (String v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(long value, long ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (long v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(double value, double ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (double v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(boolean value, boolean ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (boolean v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.sort(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRole build() {
            this._checkSingleUse();
            return new QueryRole(this);
        }
    }
}

