/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.SyncJobConnectorReference;
import co.elastic.clients.elasticsearch.connector.SyncJobTriggerMethod;
import co.elastic.clients.elasticsearch.connector.SyncJobType;
import co.elastic.clients.elasticsearch.connector.SyncStatus;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ConnectorSyncJob
implements JsonpSerializable {
    @Nullable
    private final DateTime cancelationRequestedAt;
    @Nullable
    private final DateTime canceledAt;
    @Nullable
    private final DateTime completedAt;
    private final SyncJobConnectorReference connector;
    private final DateTime createdAt;
    private final long deletedDocumentCount;
    @Nullable
    private final String error;
    private final String id;
    private final long indexedDocumentCount;
    private final long indexedDocumentVolume;
    private final SyncJobType jobType;
    @Nullable
    private final DateTime lastSeen;
    private final Map<String, JsonData> metadata;
    @Nullable
    private final DateTime startedAt;
    private final SyncStatus status;
    private final long totalDocumentCount;
    private final SyncJobTriggerMethod triggerMethod;
    @Nullable
    private final String workerHostname;
    public static final JsonpDeserializer<ConnectorSyncJob> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConnectorSyncJob::setupConnectorSyncJobDeserializer);

    protected ConnectorSyncJob(AbstractBuilder<?> builder) {
        this.cancelationRequestedAt = ((AbstractBuilder)builder).cancelationRequestedAt;
        this.canceledAt = ((AbstractBuilder)builder).canceledAt;
        this.completedAt = ((AbstractBuilder)builder).completedAt;
        this.connector = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).connector, this, "connector");
        this.createdAt = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).createdAt, this, "createdAt");
        this.deletedDocumentCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).deletedDocumentCount, this, "deletedDocumentCount");
        this.error = ((AbstractBuilder)builder).error;
        this.id = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).id, this, "id");
        this.indexedDocumentCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).indexedDocumentCount, this, "indexedDocumentCount");
        this.indexedDocumentVolume = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).indexedDocumentVolume, this, "indexedDocumentVolume");
        this.jobType = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).jobType, this, "jobType");
        this.lastSeen = ((AbstractBuilder)builder).lastSeen;
        this.metadata = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).metadata, (Object)this, "metadata");
        this.startedAt = ((AbstractBuilder)builder).startedAt;
        this.status = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).status, this, "status");
        this.totalDocumentCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).totalDocumentCount, this, "totalDocumentCount");
        this.triggerMethod = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).triggerMethod, this, "triggerMethod");
        this.workerHostname = ((AbstractBuilder)builder).workerHostname;
    }

    public static ConnectorSyncJob connectorSyncJobOf(Function<Builder, ObjectBuilder<ConnectorSyncJob>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DateTime cancelationRequestedAt() {
        return this.cancelationRequestedAt;
    }

    @Nullable
    public final DateTime canceledAt() {
        return this.canceledAt;
    }

    @Nullable
    public final DateTime completedAt() {
        return this.completedAt;
    }

    public final SyncJobConnectorReference connector() {
        return this.connector;
    }

    public final DateTime createdAt() {
        return this.createdAt;
    }

    public final long deletedDocumentCount() {
        return this.deletedDocumentCount;
    }

    @Nullable
    public final String error() {
        return this.error;
    }

    public final String id() {
        return this.id;
    }

    public final long indexedDocumentCount() {
        return this.indexedDocumentCount;
    }

    public final long indexedDocumentVolume() {
        return this.indexedDocumentVolume;
    }

    public final SyncJobType jobType() {
        return this.jobType;
    }

    @Nullable
    public final DateTime lastSeen() {
        return this.lastSeen;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final DateTime startedAt() {
        return this.startedAt;
    }

    public final SyncStatus status() {
        return this.status;
    }

    public final long totalDocumentCount() {
        return this.totalDocumentCount;
    }

    public final SyncJobTriggerMethod triggerMethod() {
        return this.triggerMethod;
    }

    @Nullable
    public final String workerHostname() {
        return this.workerHostname;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cancelationRequestedAt != null) {
            generator.writeKey("cancelation_requested_at");
            this.cancelationRequestedAt.serialize(generator, mapper);
        }
        if (this.canceledAt != null) {
            generator.writeKey("canceled_at");
            this.canceledAt.serialize(generator, mapper);
        }
        if (this.completedAt != null) {
            generator.writeKey("completed_at");
            this.completedAt.serialize(generator, mapper);
        }
        generator.writeKey("connector");
        this.connector.serialize(generator, mapper);
        generator.writeKey("created_at");
        this.createdAt.serialize(generator, mapper);
        generator.writeKey("deleted_document_count");
        generator.write(this.deletedDocumentCount);
        if (this.error != null) {
            generator.writeKey("error");
            generator.write(this.error);
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("indexed_document_count");
        generator.write(this.indexedDocumentCount);
        generator.writeKey("indexed_document_volume");
        generator.write(this.indexedDocumentVolume);
        generator.writeKey("job_type");
        this.jobType.serialize(generator, mapper);
        if (this.lastSeen != null) {
            generator.writeKey("last_seen");
            this.lastSeen.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.startedAt != null) {
            generator.writeKey("started_at");
            this.startedAt.serialize(generator, mapper);
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("total_document_count");
        generator.write(this.totalDocumentCount);
        generator.writeKey("trigger_method");
        this.triggerMethod.serialize(generator, mapper);
        if (this.workerHostname != null) {
            generator.writeKey("worker_hostname");
            generator.write(this.workerHostname);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupConnectorSyncJobDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::cancelationRequestedAt, DateTime._DESERIALIZER, "cancelation_requested_at");
        op.add(AbstractBuilder::canceledAt, DateTime._DESERIALIZER, "canceled_at");
        op.add(AbstractBuilder::completedAt, DateTime._DESERIALIZER, "completed_at");
        op.add(AbstractBuilder::connector, SyncJobConnectorReference._DESERIALIZER, "connector");
        op.add(AbstractBuilder::createdAt, DateTime._DESERIALIZER, "created_at");
        op.add(AbstractBuilder::deletedDocumentCount, JsonpDeserializer.longDeserializer(), "deleted_document_count");
        op.add(AbstractBuilder::error, JsonpDeserializer.stringDeserializer(), "error");
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(AbstractBuilder::indexedDocumentCount, JsonpDeserializer.longDeserializer(), "indexed_document_count");
        op.add(AbstractBuilder::indexedDocumentVolume, JsonpDeserializer.longDeserializer(), "indexed_document_volume");
        op.add(AbstractBuilder::jobType, SyncJobType._DESERIALIZER, "job_type");
        op.add(AbstractBuilder::lastSeen, DateTime._DESERIALIZER, "last_seen");
        op.add(AbstractBuilder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(AbstractBuilder::startedAt, DateTime._DESERIALIZER, "started_at");
        op.add(AbstractBuilder::status, SyncStatus._DESERIALIZER, "status");
        op.add(AbstractBuilder::totalDocumentCount, JsonpDeserializer.longDeserializer(), "total_document_count");
        op.add(AbstractBuilder::triggerMethod, SyncJobTriggerMethod._DESERIALIZER, "trigger_method");
        op.add(AbstractBuilder::workerHostname, JsonpDeserializer.stringDeserializer(), "worker_hostname");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private DateTime cancelationRequestedAt;
        @Nullable
        private DateTime canceledAt;
        @Nullable
        private DateTime completedAt;
        private SyncJobConnectorReference connector;
        private DateTime createdAt;
        private Long deletedDocumentCount;
        @Nullable
        private String error;
        private String id;
        private Long indexedDocumentCount;
        private Long indexedDocumentVolume;
        private SyncJobType jobType;
        @Nullable
        private DateTime lastSeen;
        private Map<String, JsonData> metadata;
        @Nullable
        private DateTime startedAt;
        private SyncStatus status;
        private Long totalDocumentCount;
        private SyncJobTriggerMethod triggerMethod;
        @Nullable
        private String workerHostname;

        public final BuilderT cancelationRequestedAt(@Nullable DateTime value) {
            this.cancelationRequestedAt = value;
            return (BuilderT)this.self();
        }

        public final BuilderT canceledAt(@Nullable DateTime value) {
            this.canceledAt = value;
            return (BuilderT)this.self();
        }

        public final BuilderT completedAt(@Nullable DateTime value) {
            this.completedAt = value;
            return (BuilderT)this.self();
        }

        public final BuilderT connector(SyncJobConnectorReference value) {
            this.connector = value;
            return (BuilderT)this.self();
        }

        public final BuilderT connector(Function<SyncJobConnectorReference.Builder, ObjectBuilder<SyncJobConnectorReference>> fn) {
            return this.connector(fn.apply(new SyncJobConnectorReference.Builder()).build());
        }

        public final BuilderT createdAt(DateTime value) {
            this.createdAt = value;
            return (BuilderT)this.self();
        }

        public final BuilderT deletedDocumentCount(long value) {
            this.deletedDocumentCount = value;
            return (BuilderT)this.self();
        }

        public final BuilderT error(@Nullable String value) {
            this.error = value;
            return (BuilderT)this.self();
        }

        public final BuilderT id(String value) {
            this.id = value;
            return (BuilderT)this.self();
        }

        public final BuilderT indexedDocumentCount(long value) {
            this.indexedDocumentCount = value;
            return (BuilderT)this.self();
        }

        public final BuilderT indexedDocumentVolume(long value) {
            this.indexedDocumentVolume = value;
            return (BuilderT)this.self();
        }

        public final BuilderT jobType(SyncJobType value) {
            this.jobType = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lastSeen(@Nullable DateTime value) {
            this.lastSeen = value;
            return (BuilderT)this.self();
        }

        public final BuilderT metadata(Map<String, JsonData> map) {
            this.metadata = AbstractBuilder._mapPutAll(this.metadata, map);
            return (BuilderT)this.self();
        }

        public final BuilderT metadata(String key, JsonData value) {
            this.metadata = AbstractBuilder._mapPut(this.metadata, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT startedAt(@Nullable DateTime value) {
            this.startedAt = value;
            return (BuilderT)this.self();
        }

        public final BuilderT status(SyncStatus value) {
            this.status = value;
            return (BuilderT)this.self();
        }

        public final BuilderT totalDocumentCount(long value) {
            this.totalDocumentCount = value;
            return (BuilderT)this.self();
        }

        public final BuilderT triggerMethod(SyncJobTriggerMethod value) {
            this.triggerMethod = value;
            return (BuilderT)this.self();
        }

        public final BuilderT workerHostname(@Nullable String value) {
            this.workerHostname = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<ConnectorSyncJob> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ConnectorSyncJob build() {
            this._checkSingleUse();
            return new ConnectorSyncJob(this);
        }
    }
}

