/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DenseVectorIndexOptions;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DenseVectorProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final String elementType;
    @Nullable
    private final Integer dims;
    @Nullable
    private final String similarity;
    @Nullable
    private final Boolean index;
    @Nullable
    private final DenseVectorIndexOptions indexOptions;
    public static final JsonpDeserializer<DenseVectorProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DenseVectorProperty::setupDenseVectorPropertyDeserializer);

    private DenseVectorProperty(Builder builder) {
        super(builder);
        this.elementType = builder.elementType;
        this.dims = builder.dims;
        this.similarity = builder.similarity;
        this.index = builder.index;
        this.indexOptions = builder.indexOptions;
    }

    public static DenseVectorProperty of(Function<Builder, ObjectBuilder<DenseVectorProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.DenseVector;
    }

    @Nullable
    public final String elementType() {
        return this.elementType;
    }

    @Nullable
    public final Integer dims() {
        return this.dims;
    }

    @Nullable
    public final String similarity() {
        return this.similarity;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final DenseVectorIndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "dense_vector");
        super.serializeInternal(generator, mapper);
        if (this.elementType != null) {
            generator.writeKey("element_type");
            generator.write(this.elementType);
        }
        if (this.dims != null) {
            generator.writeKey("dims");
            generator.write(this.dims.intValue());
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            generator.write(this.similarity);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
    }

    protected static void setupDenseVectorPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::elementType, JsonpDeserializer.stringDeserializer(), "element_type");
        op.add(Builder::dims, JsonpDeserializer.integerDeserializer(), "dims");
        op.add(Builder::similarity, JsonpDeserializer.stringDeserializer(), "similarity");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::indexOptions, DenseVectorIndexOptions._DESERIALIZER, "index_options");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DenseVectorProperty> {
        @Nullable
        private String elementType;
        @Nullable
        private Integer dims;
        @Nullable
        private String similarity;
        @Nullable
        private Boolean index;
        @Nullable
        private DenseVectorIndexOptions indexOptions;

        public final Builder elementType(@Nullable String value) {
            this.elementType = value;
            return this;
        }

        public final Builder dims(@Nullable Integer value) {
            this.dims = value;
            return this;
        }

        public final Builder similarity(@Nullable String value) {
            this.similarity = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder indexOptions(@Nullable DenseVectorIndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        public final Builder indexOptions(Function<DenseVectorIndexOptions.Builder, ObjectBuilder<DenseVectorIndexOptions>> fn) {
            return this.indexOptions(fn.apply(new DenseVectorIndexOptions.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DenseVectorProperty build() {
            this._checkSingleUse();
            return new DenseVectorProperty(this);
        }
    }
}

