/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class StagnatingBackingIndices
implements JsonpSerializable {
    private final String indexName;
    private final long firstOccurrenceTimestamp;
    private final int retryCount;
    public static final JsonpDeserializer<StagnatingBackingIndices> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StagnatingBackingIndices::setupStagnatingBackingIndicesDeserializer);

    private StagnatingBackingIndices(Builder builder) {
        this.indexName = ApiTypeHelper.requireNonNull(builder.indexName, this, "indexName");
        this.firstOccurrenceTimestamp = ApiTypeHelper.requireNonNull(builder.firstOccurrenceTimestamp, this, "firstOccurrenceTimestamp");
        this.retryCount = ApiTypeHelper.requireNonNull(builder.retryCount, this, "retryCount");
    }

    public static StagnatingBackingIndices of(Function<Builder, ObjectBuilder<StagnatingBackingIndices>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String indexName() {
        return this.indexName;
    }

    public final long firstOccurrenceTimestamp() {
        return this.firstOccurrenceTimestamp;
    }

    public final int retryCount() {
        return this.retryCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_name");
        generator.write(this.indexName);
        generator.writeKey("first_occurrence_timestamp");
        generator.write(this.firstOccurrenceTimestamp);
        generator.writeKey("retry_count");
        generator.write(this.retryCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupStagnatingBackingIndicesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexName, JsonpDeserializer.stringDeserializer(), "index_name");
        op.add(Builder::firstOccurrenceTimestamp, JsonpDeserializer.longDeserializer(), "first_occurrence_timestamp");
        op.add(Builder::retryCount, JsonpDeserializer.integerDeserializer(), "retry_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<StagnatingBackingIndices> {
        private String indexName;
        private Long firstOccurrenceTimestamp;
        private Integer retryCount;

        public final Builder indexName(String value) {
            this.indexName = value;
            return this;
        }

        public final Builder firstOccurrenceTimestamp(long value) {
            this.firstOccurrenceTimestamp = value;
            return this;
        }

        public final Builder retryCount(int value) {
            this.retryCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StagnatingBackingIndices build() {
            this._checkSingleUse();
            return new StagnatingBackingIndices(this);
        }
    }
}

