/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.FilteringRules;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FilteringConfig
implements JsonpSerializable {
    private final FilteringRules active;
    @Nullable
    private final String domain;
    private final FilteringRules draft;
    public static final JsonpDeserializer<FilteringConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FilteringConfig::setupFilteringConfigDeserializer);

    private FilteringConfig(Builder builder) {
        this.active = ApiTypeHelper.requireNonNull(builder.active, this, "active");
        this.domain = builder.domain;
        this.draft = ApiTypeHelper.requireNonNull(builder.draft, this, "draft");
    }

    public static FilteringConfig of(Function<Builder, ObjectBuilder<FilteringConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final FilteringRules active() {
        return this.active;
    }

    @Nullable
    public final String domain() {
        return this.domain;
    }

    public final FilteringRules draft() {
        return this.draft;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active");
        this.active.serialize(generator, mapper);
        if (this.domain != null) {
            generator.writeKey("domain");
            generator.write(this.domain);
        }
        generator.writeKey("draft");
        this.draft.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFilteringConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::active, FilteringRules._DESERIALIZER, "active");
        op.add(Builder::domain, JsonpDeserializer.stringDeserializer(), "domain");
        op.add(Builder::draft, FilteringRules._DESERIALIZER, "draft");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FilteringConfig> {
        private FilteringRules active;
        @Nullable
        private String domain;
        private FilteringRules draft;

        public final Builder active(FilteringRules value) {
            this.active = value;
            return this;
        }

        public final Builder active(Function<FilteringRules.Builder, ObjectBuilder<FilteringRules>> fn) {
            return this.active(fn.apply(new FilteringRules.Builder()).build());
        }

        public final Builder domain(@Nullable String value) {
            this.domain = value;
            return this;
        }

        public final Builder draft(FilteringRules value) {
            this.draft = value;
            return this;
        }

        public final Builder draft(Function<FilteringRules.Builder, ObjectBuilder<FilteringRules>> fn) {
            return this.draft(fn.apply(new FilteringRules.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FilteringConfig build() {
            this._checkSingleUse();
            return new FilteringConfig(this);
        }
    }
}

