/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DenseVectorIndexOptions
implements JsonpSerializable {
    private final String type;
    @Nullable
    private final Integer m;
    @Nullable
    private final Integer efConstruction;
    @Nullable
    private final Float confidenceInterval;
    public static final JsonpDeserializer<DenseVectorIndexOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DenseVectorIndexOptions::setupDenseVectorIndexOptionsDeserializer);

    private DenseVectorIndexOptions(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.m = builder.m;
        this.efConstruction = builder.efConstruction;
        this.confidenceInterval = builder.confidenceInterval;
    }

    public static DenseVectorIndexOptions of(Function<Builder, ObjectBuilder<DenseVectorIndexOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final Integer m() {
        return this.m;
    }

    @Nullable
    public final Integer efConstruction() {
        return this.efConstruction;
    }

    @Nullable
    public final Float confidenceInterval() {
        return this.confidenceInterval;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        if (this.m != null) {
            generator.writeKey("m");
            generator.write(this.m.intValue());
        }
        if (this.efConstruction != null) {
            generator.writeKey("ef_construction");
            generator.write(this.efConstruction.intValue());
        }
        if (this.confidenceInterval != null) {
            generator.writeKey("confidence_interval");
            generator.write((double)this.confidenceInterval.floatValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDenseVectorIndexOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::m, JsonpDeserializer.integerDeserializer(), "m");
        op.add(Builder::efConstruction, JsonpDeserializer.integerDeserializer(), "ef_construction");
        op.add(Builder::confidenceInterval, JsonpDeserializer.floatDeserializer(), "confidence_interval");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DenseVectorIndexOptions> {
        private String type;
        @Nullable
        private Integer m;
        @Nullable
        private Integer efConstruction;
        @Nullable
        private Float confidenceInterval;

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder m(@Nullable Integer value) {
            this.m = value;
            return this;
        }

        public final Builder efConstruction(@Nullable Integer value) {
            this.efConstruction = value;
            return this;
        }

        public final Builder confidenceInterval(@Nullable Float value) {
            this.confidenceInterval = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DenseVectorIndexOptions build() {
            this._checkSingleUse();
            return new DenseVectorIndexOptions(this);
        }
    }
}

