/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.simulate;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.ingest.simulate.DocumentSimulation;
import co.elastic.clients.elasticsearch.ingest.simulate.PipelineSimulation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SimulateDocumentResult
implements JsonpSerializable {
    @Nullable
    private final DocumentSimulation doc;
    @Nullable
    private final ErrorCause error;
    private final List<PipelineSimulation> processorResults;
    public static final JsonpDeserializer<SimulateDocumentResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulateDocumentResult::setupSimulateDocumentResultDeserializer);

    private SimulateDocumentResult(Builder builder) {
        this.doc = builder.doc;
        this.error = builder.error;
        this.processorResults = ApiTypeHelper.unmodifiable(builder.processorResults);
    }

    public static SimulateDocumentResult of(Function<Builder, ObjectBuilder<SimulateDocumentResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DocumentSimulation doc() {
        return this.doc;
    }

    @Nullable
    public final ErrorCause error() {
        return this.error;
    }

    public final List<PipelineSimulation> processorResults() {
        return this.processorResults;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            this.doc.serialize(generator, mapper);
        }
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.processorResults)) {
            generator.writeKey("processor_results");
            generator.writeStartArray();
            for (PipelineSimulation item0 : this.processorResults) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSimulateDocumentResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::doc, DocumentSimulation._DESERIALIZER, "doc");
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
        op.add(Builder::processorResults, JsonpDeserializer.arrayDeserializer(PipelineSimulation._DESERIALIZER), "processor_results");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SimulateDocumentResult> {
        @Nullable
        private DocumentSimulation doc;
        @Nullable
        private ErrorCause error;
        @Nullable
        private List<PipelineSimulation> processorResults;

        public final Builder doc(@Nullable DocumentSimulation value) {
            this.doc = value;
            return this;
        }

        public final Builder doc(Function<DocumentSimulation.Builder, ObjectBuilder<DocumentSimulation>> fn) {
            return this.doc(fn.apply(new DocumentSimulation.Builder()).build());
        }

        public final Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder processorResults(List<PipelineSimulation> list) {
            this.processorResults = Builder._listAddAll(this.processorResults, list);
            return this;
        }

        public final Builder processorResults(PipelineSimulation value, PipelineSimulation ... values) {
            this.processorResults = Builder._listAdd(this.processorResults, value, values);
            return this;
        }

        public final Builder processorResults(Function<PipelineSimulation.Builder, ObjectBuilder<PipelineSimulation>> fn) {
            return this.processorResults(fn.apply(new PipelineSimulation.Builder()).build(), new PipelineSimulation[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SimulateDocumentResult build() {
            this._checkSingleUse();
            return new SimulateDocumentResult(this);
        }
    }
}

