/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.InferenceEndpoint;
import co.elastic.clients.elasticsearch.inference.TaskType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InferenceEndpointInfo
extends InferenceEndpoint {
    private final String inferenceId;
    private final TaskType taskType;
    public static final JsonpDeserializer<InferenceEndpointInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceEndpointInfo::setupInferenceEndpointInfoDeserializer);

    protected InferenceEndpointInfo(AbstractBuilder<?> builder) {
        super(builder);
        this.inferenceId = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).inferenceId, this, "inferenceId");
        this.taskType = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).taskType, this, "taskType");
    }

    public static InferenceEndpointInfo inferenceEndpointInfoOf(Function<Builder, ObjectBuilder<InferenceEndpointInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    public final TaskType taskType() {
        return this.taskType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("inference_id");
        generator.write(this.inferenceId);
        generator.writeKey("task_type");
        this.taskType.serialize(generator, mapper);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupInferenceEndpointInfoDeserializer(ObjectDeserializer<BuilderT> op) {
        InferenceEndpoint.setupInferenceEndpointDeserializer(op);
        op.add(AbstractBuilder::inferenceId, JsonpDeserializer.stringDeserializer(), "inference_id");
        op.add(AbstractBuilder::taskType, TaskType._DESERIALIZER, "task_type");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends InferenceEndpoint.AbstractBuilder<BuilderT> {
        private String inferenceId;
        private TaskType taskType;

        public final BuilderT inferenceId(String value) {
            this.inferenceId = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT taskType(TaskType value) {
            this.taskType = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<InferenceEndpointInfo> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceEndpointInfo build() {
            this._checkSingleUse();
            return new InferenceEndpointInfo(this);
        }
    }
}

