/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.snapshot.RepositoryVerifyIntegrityResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class RepositoryVerifyIntegrityRequest
extends RequestBase {
    @Nullable
    private final Integer blobThreadPoolConcurrency;
    @Nullable
    private final Integer indexSnapshotVerificationConcurrency;
    @Nullable
    private final Integer indexVerificationConcurrency;
    @Nullable
    private final String maxBytesPerSec;
    @Nullable
    private final Integer maxFailedShardSnapshots;
    @Nullable
    private final Integer metaThreadPoolConcurrency;
    private final List<String> name;
    @Nullable
    private final Integer snapshotVerificationConcurrency;
    @Nullable
    private final Boolean verifyBlobContents;
    public static final Endpoint<RepositoryVerifyIntegrityRequest, RepositoryVerifyIntegrityResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RepositoryVerifyIntegrityRequest, RepositoryVerifyIntegrityResponse>("es/snapshot.repository_verify_integrity", request -> "POST", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_verify_integrity");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.maxFailedShardSnapshots != null) {
            params.put("max_failed_shard_snapshots", String.valueOf(request.maxFailedShardSnapshots));
        }
        if (request.snapshotVerificationConcurrency != null) {
            params.put("snapshot_verification_concurrency", String.valueOf(request.snapshotVerificationConcurrency));
        }
        if (request.metaThreadPoolConcurrency != null) {
            params.put("meta_thread_pool_concurrency", String.valueOf(request.metaThreadPoolConcurrency));
        }
        if (request.blobThreadPoolConcurrency != null) {
            params.put("blob_thread_pool_concurrency", String.valueOf(request.blobThreadPoolConcurrency));
        }
        if (request.indexVerificationConcurrency != null) {
            params.put("index_verification_concurrency", String.valueOf(request.indexVerificationConcurrency));
        }
        if (request.indexSnapshotVerificationConcurrency != null) {
            params.put("index_snapshot_verification_concurrency", String.valueOf(request.indexSnapshotVerificationConcurrency));
        }
        if (request.verifyBlobContents != null) {
            params.put("verify_blob_contents", String.valueOf(request.verifyBlobContents));
        }
        if (request.maxBytesPerSec != null) {
            params.put("max_bytes_per_sec", request.maxBytesPerSec);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, RepositoryVerifyIntegrityResponse._DESERIALIZER);

    private RepositoryVerifyIntegrityRequest(Builder builder) {
        this.blobThreadPoolConcurrency = builder.blobThreadPoolConcurrency;
        this.indexSnapshotVerificationConcurrency = builder.indexSnapshotVerificationConcurrency;
        this.indexVerificationConcurrency = builder.indexVerificationConcurrency;
        this.maxBytesPerSec = builder.maxBytesPerSec;
        this.maxFailedShardSnapshots = builder.maxFailedShardSnapshots;
        this.metaThreadPoolConcurrency = builder.metaThreadPoolConcurrency;
        this.name = ApiTypeHelper.unmodifiableRequired(builder.name, (Object)this, "name");
        this.snapshotVerificationConcurrency = builder.snapshotVerificationConcurrency;
        this.verifyBlobContents = builder.verifyBlobContents;
    }

    public static RepositoryVerifyIntegrityRequest of(Function<Builder, ObjectBuilder<RepositoryVerifyIntegrityRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer blobThreadPoolConcurrency() {
        return this.blobThreadPoolConcurrency;
    }

    @Nullable
    public final Integer indexSnapshotVerificationConcurrency() {
        return this.indexSnapshotVerificationConcurrency;
    }

    @Nullable
    public final Integer indexVerificationConcurrency() {
        return this.indexVerificationConcurrency;
    }

    @Nullable
    public final String maxBytesPerSec() {
        return this.maxBytesPerSec;
    }

    @Nullable
    public final Integer maxFailedShardSnapshots() {
        return this.maxFailedShardSnapshots;
    }

    @Nullable
    public final Integer metaThreadPoolConcurrency() {
        return this.metaThreadPoolConcurrency;
    }

    public final List<String> name() {
        return this.name;
    }

    @Nullable
    public final Integer snapshotVerificationConcurrency() {
        return this.snapshotVerificationConcurrency;
    }

    @Nullable
    public final Boolean verifyBlobContents() {
        return this.verifyBlobContents;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RepositoryVerifyIntegrityRequest> {
        @Nullable
        private Integer blobThreadPoolConcurrency;
        @Nullable
        private Integer indexSnapshotVerificationConcurrency;
        @Nullable
        private Integer indexVerificationConcurrency;
        @Nullable
        private String maxBytesPerSec;
        @Nullable
        private Integer maxFailedShardSnapshots;
        @Nullable
        private Integer metaThreadPoolConcurrency;
        private List<String> name;
        @Nullable
        private Integer snapshotVerificationConcurrency;
        @Nullable
        private Boolean verifyBlobContents;

        public final Builder blobThreadPoolConcurrency(@Nullable Integer value) {
            this.blobThreadPoolConcurrency = value;
            return this;
        }

        public final Builder indexSnapshotVerificationConcurrency(@Nullable Integer value) {
            this.indexSnapshotVerificationConcurrency = value;
            return this;
        }

        public final Builder indexVerificationConcurrency(@Nullable Integer value) {
            this.indexVerificationConcurrency = value;
            return this;
        }

        public final Builder maxBytesPerSec(@Nullable String value) {
            this.maxBytesPerSec = value;
            return this;
        }

        public final Builder maxFailedShardSnapshots(@Nullable Integer value) {
            this.maxFailedShardSnapshots = value;
            return this;
        }

        public final Builder metaThreadPoolConcurrency(@Nullable Integer value) {
            this.metaThreadPoolConcurrency = value;
            return this;
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder snapshotVerificationConcurrency(@Nullable Integer value) {
            this.snapshotVerificationConcurrency = value;
            return this;
        }

        public final Builder verifyBlobContents(@Nullable Boolean value) {
            this.verifyBlobContents = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RepositoryVerifyIntegrityRequest build() {
            this._checkSingleUse();
            return new RepositoryVerifyIntegrityRequest(this);
        }
    }
}

