/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class JsonpMapperBase
implements JsonpMapper {
    private Map<String, Object> attributes;

    protected abstract <T> JsonpDeserializer<T> getDefaultDeserializer(Type var1);

    @Override
    @Nullable
    public <T> T attribute(String name) {
        return (T)(this.attributes == null ? null : this.attributes.get(name));
    }

    protected JsonpMapperBase addAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = Collections.singletonMap(name, value);
        } else {
            HashMap<String, Object> newAttrs = new HashMap<String, Object>(this.attributes.size() + 1);
            newAttrs.putAll(this.attributes);
            newAttrs.put(name, value);
            this.attributes = newAttrs;
        }
        return this;
    }

    @Override
    public <T> T deserialize(JsonParser parser, Type type) {
        T result = this.getDeserializer(type).deserialize(parser, this);
        return result;
    }

    @Override
    public <T> T deserialize(JsonParser parser, Type type, JsonParser.Event event) {
        T result = this.getDeserializer(type).deserialize(parser, this, event);
        return result;
    }

    private <T> JsonpDeserializer<T> getDeserializer(Type type) {
        JsonpDeserializer<T> deserializer = JsonpMapperBase.findDeserializer(type);
        if (deserializer != null) {
            return deserializer;
        }
        JsonpDeserializer<T> result = this.getDefaultDeserializer(type);
        return result;
    }

    @Nullable
    public static <T> JsonpDeserializer<T> findDeserializer(Class<T> clazz) {
        return JsonpMapperBase.findDeserializer(clazz);
    }

    @Nullable
    public static <T> JsonpDeserializer<T> findDeserializer(Type type) {
        Class clazz;
        JsonpDeserializable annotation;
        if (type instanceof Class && (annotation = (clazz = (Class)type).getAnnotation(JsonpDeserializable.class)) != null) {
            try {
                Field field = clazz.getDeclaredField(annotation.field());
                return (JsonpDeserializer)field.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException("No deserializer found in '" + clazz.getName() + "." + annotation.field() + "'");
            }
        }
        if (type == Void.class) {
            return JsonpDeserializerBase.VOID;
        }
        return null;
    }

    @Nullable
    public static <T> JsonpSerializer<T> findSerializer(T value) {
        Class<?> valueClass = value.getClass();
        if (JsonpSerializable.class.isAssignableFrom(valueClass)) {
            return JsonpSerializableSerializer.INSTANCE;
        }
        if (JsonValue.class.isAssignableFrom(valueClass)) {
            return JsonpValueSerializer.INSTANCE;
        }
        return null;
    }

    protected static class JsonpSerializableSerializer<T extends JsonpSerializable>
    implements JsonpSerializer<T> {
        protected static final JsonpSerializer<?> INSTANCE = new JsonpSerializableSerializer();

        protected JsonpSerializableSerializer() {
        }

        @Override
        public void serialize(T value, JsonGenerator generator, JsonpMapper mapper) {
            value.serialize(generator, mapper);
        }
    }

    protected static class JsonpValueSerializer
    implements JsonpSerializer<JsonValue> {
        protected static final JsonpSerializer<?> INSTANCE = new JsonpValueSerializer();

        protected JsonpValueSerializer() {
        }

        @Override
        public void serialize(JsonValue value, JsonGenerator generator, JsonpMapper mapper) {
            generator.write(value);
        }
    }
}

