/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.analysis.Analyzer;
import co.elastic.clients.elasticsearch._types.analysis.CharFilter;
import co.elastic.clients.elasticsearch._types.analysis.Normalizer;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.Tokenizer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexSettingsAnalysis
implements JsonpSerializable {
    private final Map<String, Analyzer> analyzer;
    private final Map<String, CharFilter> charFilter;
    private final Map<String, TokenFilter> filter;
    private final Map<String, Normalizer> normalizer;
    private final Map<String, Tokenizer> tokenizer;
    public static final JsonpDeserializer<IndexSettingsAnalysis> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsAnalysis::setupIndexSettingsAnalysisDeserializer);

    private IndexSettingsAnalysis(Builder builder) {
        this.analyzer = ApiTypeHelper.unmodifiable(builder.analyzer);
        this.charFilter = ApiTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.normalizer = ApiTypeHelper.unmodifiable(builder.normalizer);
        this.tokenizer = ApiTypeHelper.unmodifiable(builder.tokenizer);
    }

    public static IndexSettingsAnalysis of(Function<Builder, ObjectBuilder<IndexSettingsAnalysis>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Analyzer> analyzer() {
        return this.analyzer;
    }

    public final Map<String, CharFilter> charFilter() {
        return this.charFilter;
    }

    public final Map<String, TokenFilter> filter() {
        return this.filter;
    }

    public final Map<String, Normalizer> normalizer() {
        return this.normalizer;
    }

    public final Map<String, Tokenizer> tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.analyzer)) {
            generator.writeKey("analyzer");
            generator.writeStartObject();
            for (Map.Entry<String, Analyzer> entry : this.analyzer.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.charFilter)) {
            generator.writeKey("char_filter");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.charFilter.entrySet()) {
                generator.writeKey(entry.getKey());
                ((CharFilter)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.filter.entrySet()) {
                generator.writeKey(entry.getKey());
                ((TokenFilter)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.normalizer)) {
            generator.writeKey("normalizer");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.normalizer.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Normalizer)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.tokenizer)) {
            generator.writeKey("tokenizer");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.tokenizer.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Tokenizer)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndexSettingsAnalysisDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringMapDeserializer(Analyzer._DESERIALIZER), "analyzer");
        op.add(Builder::charFilter, JsonpDeserializer.stringMapDeserializer(CharFilter._DESERIALIZER), "char_filter");
        op.add(Builder::filter, JsonpDeserializer.stringMapDeserializer(TokenFilter._DESERIALIZER), "filter");
        op.add(Builder::normalizer, JsonpDeserializer.stringMapDeserializer(Normalizer._DESERIALIZER), "normalizer");
        op.add(Builder::tokenizer, JsonpDeserializer.stringMapDeserializer(Tokenizer._DESERIALIZER), "tokenizer");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexSettingsAnalysis> {
        @Nullable
        private Map<String, Analyzer> analyzer;
        @Nullable
        private Map<String, CharFilter> charFilter;
        @Nullable
        private Map<String, TokenFilter> filter;
        @Nullable
        private Map<String, Normalizer> normalizer;
        @Nullable
        private Map<String, Tokenizer> tokenizer;

        public final Builder analyzer(Map<String, Analyzer> map) {
            this.analyzer = Builder._mapPutAll(this.analyzer, map);
            return this;
        }

        public final Builder analyzer(String key, Analyzer value) {
            this.analyzer = Builder._mapPut(this.analyzer, key, value);
            return this;
        }

        public final Builder analyzer(String key, Function<Analyzer.Builder, ObjectBuilder<Analyzer>> fn) {
            return this.analyzer(key, fn.apply(new Analyzer.Builder()).build());
        }

        public final Builder charFilter(Map<String, CharFilter> map) {
            this.charFilter = Builder._mapPutAll(this.charFilter, map);
            return this;
        }

        public final Builder charFilter(String key, CharFilter value) {
            this.charFilter = Builder._mapPut(this.charFilter, key, value);
            return this;
        }

        public final Builder charFilter(String key, Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.charFilter(key, fn.apply(new CharFilter.Builder()).build());
        }

        public final Builder filter(Map<String, TokenFilter> map) {
            this.filter = Builder._mapPutAll(this.filter, map);
            return this;
        }

        public final Builder filter(String key, TokenFilter value) {
            this.filter = Builder._mapPut(this.filter, key, value);
            return this;
        }

        public final Builder filter(String key, Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.filter(key, fn.apply(new TokenFilter.Builder()).build());
        }

        public final Builder normalizer(Map<String, Normalizer> map) {
            this.normalizer = Builder._mapPutAll(this.normalizer, map);
            return this;
        }

        public final Builder normalizer(String key, Normalizer value) {
            this.normalizer = Builder._mapPut(this.normalizer, key, value);
            return this;
        }

        public final Builder normalizer(String key, Function<Normalizer.Builder, ObjectBuilder<Normalizer>> fn) {
            return this.normalizer(key, fn.apply(new Normalizer.Builder()).build());
        }

        public final Builder tokenizer(Map<String, Tokenizer> map) {
            this.tokenizer = Builder._mapPutAll(this.tokenizer, map);
            return this;
        }

        public final Builder tokenizer(String key, Tokenizer value) {
            this.tokenizer = Builder._mapPut(this.tokenizer, key, value);
            return this;
        }

        public final Builder tokenizer(String key, Function<Tokenizer.Builder, ObjectBuilder<Tokenizer>> fn) {
            return this.tokenizer(key, fn.apply(new Tokenizer.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexSettingsAnalysis build() {
            this._checkSingleUse();
            return new IndexSettingsAnalysis(this);
        }
    }
}

