/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.Counter;
import co.elastic.clients.elasticsearch.xpack.usage.WatcherActions;
import co.elastic.clients.elasticsearch.xpack.usage.WatcherWatch;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Watcher
extends Base {
    private final WatcherActions execution;
    private final WatcherWatch watch;
    private final Counter count;
    public static final JsonpDeserializer<Watcher> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Watcher::setupWatcherDeserializer);

    private Watcher(Builder builder) {
        super(builder);
        this.execution = ApiTypeHelper.requireNonNull(builder.execution, this, "execution");
        this.watch = ApiTypeHelper.requireNonNull(builder.watch, this, "watch");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
    }

    public static Watcher of(Function<Builder, ObjectBuilder<Watcher>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final WatcherActions execution() {
        return this.execution;
    }

    public final WatcherWatch watch() {
        return this.watch;
    }

    public final Counter count() {
        return this.count;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("execution");
        this.execution.serialize(generator, mapper);
        generator.writeKey("watch");
        this.watch.serialize(generator, mapper);
        generator.writeKey("count");
        this.count.serialize(generator, mapper);
    }

    protected static void setupWatcherDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::execution, WatcherActions._DESERIALIZER, "execution");
        op.add(Builder::watch, WatcherWatch._DESERIALIZER, "watch");
        op.add(Builder::count, Counter._DESERIALIZER, "count");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Watcher> {
        private WatcherActions execution;
        private WatcherWatch watch;
        private Counter count;

        public final Builder execution(WatcherActions value) {
            this.execution = value;
            return this;
        }

        public final Builder execution(Function<WatcherActions.Builder, ObjectBuilder<WatcherActions>> fn) {
            return this.execution(fn.apply(new WatcherActions.Builder()).build());
        }

        public final Builder watch(WatcherWatch value) {
            this.watch = value;
            return this;
        }

        public final Builder watch(Function<WatcherWatch.Builder, ObjectBuilder<WatcherWatch>> fn) {
            return this.watch(fn.apply(new WatcherWatch.Builder()).build());
        }

        public final Builder count(Counter value) {
            this.count = value;
            return this;
        }

        public final Builder count(Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.count(fn.apply(new Counter.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Watcher build() {
            this._checkSingleUse();
            return new Watcher(this);
        }
    }
}

