/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.simulate;

import co.elastic.clients.elasticsearch.ingest.simulate.Redact;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Ingest
implements JsonpSerializable {
    @Nullable
    private final Redact redact;
    private final DateTime timestamp;
    @Nullable
    private final String pipeline;
    public static final JsonpDeserializer<Ingest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ingest::setupIngestDeserializer);

    private Ingest(Builder builder) {
        this.redact = builder.redact;
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
        this.pipeline = builder.pipeline;
    }

    public static Ingest of(Function<Builder, ObjectBuilder<Ingest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Redact redact() {
        return this.redact;
    }

    public final DateTime timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.redact != null) {
            generator.writeKey("_redact");
            this.redact.serialize(generator, mapper);
        }
        generator.writeKey("timestamp");
        this.timestamp.serialize(generator, mapper);
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            generator.write(this.pipeline);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIngestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::redact, Redact._DESERIALIZER, "_redact");
        op.add(Builder::timestamp, DateTime._DESERIALIZER, "timestamp");
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Ingest> {
        @Nullable
        private Redact redact;
        private DateTime timestamp;
        @Nullable
        private String pipeline;

        public final Builder redact(@Nullable Redact value) {
            this.redact = value;
            return this;
        }

        public final Builder redact(Function<Redact.Builder, ObjectBuilder<Redact>> fn) {
            return this.redact(fn.apply(new Redact.Builder()).build());
        }

        public final Builder timestamp(DateTime value) {
            this.timestamp = value;
            return this;
        }

        public final Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Ingest build() {
            this._checkSingleUse();
            return new Ingest(this);
        }
    }
}

