/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RunningStateSearchInterval
implements JsonpSerializable {
    @Nullable
    private final Time end;
    private final long endMs;
    @Nullable
    private final Time start;
    private final long startMs;
    public static final JsonpDeserializer<RunningStateSearchInterval> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RunningStateSearchInterval::setupRunningStateSearchIntervalDeserializer);

    private RunningStateSearchInterval(Builder builder) {
        this.end = builder.end;
        this.endMs = ApiTypeHelper.requireNonNull(builder.endMs, this, "endMs");
        this.start = builder.start;
        this.startMs = ApiTypeHelper.requireNonNull(builder.startMs, this, "startMs");
    }

    public static RunningStateSearchInterval of(Function<Builder, ObjectBuilder<RunningStateSearchInterval>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time end() {
        return this.end;
    }

    public final long endMs() {
        return this.endMs;
    }

    @Nullable
    public final Time start() {
        return this.start;
    }

    public final long startMs() {
        return this.startMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.end != null) {
            generator.writeKey("end");
            this.end.serialize(generator, mapper);
        }
        generator.writeKey("end_ms");
        generator.write(this.endMs);
        if (this.start != null) {
            generator.writeKey("start");
            this.start.serialize(generator, mapper);
        }
        generator.writeKey("start_ms");
        generator.write(this.startMs);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRunningStateSearchIntervalDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::end, Time._DESERIALIZER, "end");
        op.add(Builder::endMs, JsonpDeserializer.longDeserializer(), "end_ms");
        op.add(Builder::start, Time._DESERIALIZER, "start");
        op.add(Builder::startMs, JsonpDeserializer.longDeserializer(), "start_ms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RunningStateSearchInterval> {
        @Nullable
        private Time end;
        private Long endMs;
        @Nullable
        private Time start;
        private Long startMs;

        public final Builder end(@Nullable Time value) {
            this.end = value;
            return this;
        }

        public final Builder end(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.end(fn.apply(new Time.Builder()).build());
        }

        public final Builder endMs(long value) {
            this.endMs = value;
            return this;
        }

        public final Builder start(@Nullable Time value) {
            this.start = value;
            return this;
        }

        public final Builder start(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.start(fn.apply(new Time.Builder()).build());
        }

        public final Builder startMs(long value) {
            this.startMs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RunningStateSearchInterval build() {
            this._checkSingleUse();
            return new RunningStateSearchInterval(this);
        }
    }
}

