/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.AppendProcessor;
import co.elastic.clients.elasticsearch.ingest.AttachmentProcessor;
import co.elastic.clients.elasticsearch.ingest.BytesProcessor;
import co.elastic.clients.elasticsearch.ingest.CircleProcessor;
import co.elastic.clients.elasticsearch.ingest.ConvertProcessor;
import co.elastic.clients.elasticsearch.ingest.CsvProcessor;
import co.elastic.clients.elasticsearch.ingest.DateIndexNameProcessor;
import co.elastic.clients.elasticsearch.ingest.DateProcessor;
import co.elastic.clients.elasticsearch.ingest.DissectProcessor;
import co.elastic.clients.elasticsearch.ingest.DotExpanderProcessor;
import co.elastic.clients.elasticsearch.ingest.DropProcessor;
import co.elastic.clients.elasticsearch.ingest.EnrichProcessor;
import co.elastic.clients.elasticsearch.ingest.FailProcessor;
import co.elastic.clients.elasticsearch.ingest.ForeachProcessor;
import co.elastic.clients.elasticsearch.ingest.GeoGridProcessor;
import co.elastic.clients.elasticsearch.ingest.GeoIpProcessor;
import co.elastic.clients.elasticsearch.ingest.GrokProcessor;
import co.elastic.clients.elasticsearch.ingest.GsubProcessor;
import co.elastic.clients.elasticsearch.ingest.HtmlStripProcessor;
import co.elastic.clients.elasticsearch.ingest.InferenceProcessor;
import co.elastic.clients.elasticsearch.ingest.JoinProcessor;
import co.elastic.clients.elasticsearch.ingest.JsonProcessor;
import co.elastic.clients.elasticsearch.ingest.KeyValueProcessor;
import co.elastic.clients.elasticsearch.ingest.LowercaseProcessor;
import co.elastic.clients.elasticsearch.ingest.PipelineProcessor;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.elasticsearch.ingest.RedactProcessor;
import co.elastic.clients.elasticsearch.ingest.RemoveProcessor;
import co.elastic.clients.elasticsearch.ingest.RenameProcessor;
import co.elastic.clients.elasticsearch.ingest.RerouteProcessor;
import co.elastic.clients.elasticsearch.ingest.ScriptProcessor;
import co.elastic.clients.elasticsearch.ingest.SetProcessor;
import co.elastic.clients.elasticsearch.ingest.SetSecurityUserProcessor;
import co.elastic.clients.elasticsearch.ingest.SortProcessor;
import co.elastic.clients.elasticsearch.ingest.SplitProcessor;
import co.elastic.clients.elasticsearch.ingest.TrimProcessor;
import co.elastic.clients.elasticsearch.ingest.UppercaseProcessor;
import co.elastic.clients.elasticsearch.ingest.UriPartsProcessor;
import co.elastic.clients.elasticsearch.ingest.UrlDecodeProcessor;
import co.elastic.clients.elasticsearch.ingest.UserAgentProcessor;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Processor
implements OpenTaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    @Nullable
    private final String _customKind;
    public static final JsonpDeserializer<Processor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Processor::setupProcessorDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Processor(ProcessorVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._processorKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this._customKind = null;
    }

    private Processor(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this._customKind = builder._customKind;
    }

    public static Processor of(Function<Builder, ObjectBuilder<Processor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isAppend() {
        return this._kind == Kind.Append;
    }

    public AppendProcessor append() {
        return (AppendProcessor)TaggedUnionUtils.get(this, Kind.Append);
    }

    public boolean isAttachment() {
        return this._kind == Kind.Attachment;
    }

    public AttachmentProcessor attachment() {
        return (AttachmentProcessor)TaggedUnionUtils.get(this, Kind.Attachment);
    }

    public boolean isBytes() {
        return this._kind == Kind.Bytes;
    }

    public BytesProcessor bytes() {
        return (BytesProcessor)TaggedUnionUtils.get(this, Kind.Bytes);
    }

    public boolean isCircle() {
        return this._kind == Kind.Circle;
    }

    public CircleProcessor circle() {
        return (CircleProcessor)TaggedUnionUtils.get(this, Kind.Circle);
    }

    public boolean isConvert() {
        return this._kind == Kind.Convert;
    }

    public ConvertProcessor convert() {
        return (ConvertProcessor)TaggedUnionUtils.get(this, Kind.Convert);
    }

    public boolean isCsv() {
        return this._kind == Kind.Csv;
    }

    public CsvProcessor csv() {
        return (CsvProcessor)TaggedUnionUtils.get(this, Kind.Csv);
    }

    public boolean isDate() {
        return this._kind == Kind.Date;
    }

    public DateProcessor date() {
        return (DateProcessor)TaggedUnionUtils.get(this, Kind.Date);
    }

    public boolean isDateIndexName() {
        return this._kind == Kind.DateIndexName;
    }

    public DateIndexNameProcessor dateIndexName() {
        return (DateIndexNameProcessor)TaggedUnionUtils.get(this, Kind.DateIndexName);
    }

    public boolean isDissect() {
        return this._kind == Kind.Dissect;
    }

    public DissectProcessor dissect() {
        return (DissectProcessor)TaggedUnionUtils.get(this, Kind.Dissect);
    }

    public boolean isDotExpander() {
        return this._kind == Kind.DotExpander;
    }

    public DotExpanderProcessor dotExpander() {
        return (DotExpanderProcessor)TaggedUnionUtils.get(this, Kind.DotExpander);
    }

    public boolean isDrop() {
        return this._kind == Kind.Drop;
    }

    public DropProcessor drop() {
        return (DropProcessor)TaggedUnionUtils.get(this, Kind.Drop);
    }

    public boolean isEnrich() {
        return this._kind == Kind.Enrich;
    }

    public EnrichProcessor enrich() {
        return (EnrichProcessor)TaggedUnionUtils.get(this, Kind.Enrich);
    }

    public boolean isFail() {
        return this._kind == Kind.Fail;
    }

    public FailProcessor fail() {
        return (FailProcessor)TaggedUnionUtils.get(this, Kind.Fail);
    }

    public boolean isForeach() {
        return this._kind == Kind.Foreach;
    }

    public ForeachProcessor foreach() {
        return (ForeachProcessor)TaggedUnionUtils.get(this, Kind.Foreach);
    }

    public boolean isGeoGrid() {
        return this._kind == Kind.GeoGrid;
    }

    public GeoGridProcessor geoGrid() {
        return (GeoGridProcessor)TaggedUnionUtils.get(this, Kind.GeoGrid);
    }

    public boolean isGeoip() {
        return this._kind == Kind.Geoip;
    }

    public GeoIpProcessor geoip() {
        return (GeoIpProcessor)TaggedUnionUtils.get(this, Kind.Geoip);
    }

    public boolean isGrok() {
        return this._kind == Kind.Grok;
    }

    public GrokProcessor grok() {
        return (GrokProcessor)TaggedUnionUtils.get(this, Kind.Grok);
    }

    public boolean isGsub() {
        return this._kind == Kind.Gsub;
    }

    public GsubProcessor gsub() {
        return (GsubProcessor)TaggedUnionUtils.get(this, Kind.Gsub);
    }

    public boolean isHtmlStrip() {
        return this._kind == Kind.HtmlStrip;
    }

    public HtmlStripProcessor htmlStrip() {
        return (HtmlStripProcessor)TaggedUnionUtils.get(this, Kind.HtmlStrip);
    }

    public boolean isInference() {
        return this._kind == Kind.Inference;
    }

    public InferenceProcessor inference() {
        return (InferenceProcessor)TaggedUnionUtils.get(this, Kind.Inference);
    }

    public boolean isJoin() {
        return this._kind == Kind.Join;
    }

    public JoinProcessor join() {
        return (JoinProcessor)TaggedUnionUtils.get(this, Kind.Join);
    }

    public boolean isJson() {
        return this._kind == Kind.Json;
    }

    public JsonProcessor json() {
        return (JsonProcessor)TaggedUnionUtils.get(this, Kind.Json);
    }

    public boolean isKv() {
        return this._kind == Kind.Kv;
    }

    public KeyValueProcessor kv() {
        return (KeyValueProcessor)TaggedUnionUtils.get(this, Kind.Kv);
    }

    public boolean isLowercase() {
        return this._kind == Kind.Lowercase;
    }

    public LowercaseProcessor lowercase() {
        return (LowercaseProcessor)TaggedUnionUtils.get(this, Kind.Lowercase);
    }

    public boolean isPipeline() {
        return this._kind == Kind.Pipeline;
    }

    public PipelineProcessor pipeline() {
        return (PipelineProcessor)TaggedUnionUtils.get(this, Kind.Pipeline);
    }

    public boolean isRedact() {
        return this._kind == Kind.Redact;
    }

    public RedactProcessor redact() {
        return (RedactProcessor)TaggedUnionUtils.get(this, Kind.Redact);
    }

    public boolean isRemove() {
        return this._kind == Kind.Remove;
    }

    public RemoveProcessor remove() {
        return (RemoveProcessor)TaggedUnionUtils.get(this, Kind.Remove);
    }

    public boolean isRename() {
        return this._kind == Kind.Rename;
    }

    public RenameProcessor rename() {
        return (RenameProcessor)TaggedUnionUtils.get(this, Kind.Rename);
    }

    public boolean isReroute() {
        return this._kind == Kind.Reroute;
    }

    public RerouteProcessor reroute() {
        return (RerouteProcessor)TaggedUnionUtils.get(this, Kind.Reroute);
    }

    public boolean isScript() {
        return this._kind == Kind.Script;
    }

    public ScriptProcessor script() {
        return (ScriptProcessor)TaggedUnionUtils.get(this, Kind.Script);
    }

    public boolean isSet() {
        return this._kind == Kind.Set;
    }

    public SetProcessor set() {
        return (SetProcessor)TaggedUnionUtils.get(this, Kind.Set);
    }

    public boolean isSetSecurityUser() {
        return this._kind == Kind.SetSecurityUser;
    }

    public SetSecurityUserProcessor setSecurityUser() {
        return (SetSecurityUserProcessor)TaggedUnionUtils.get(this, Kind.SetSecurityUser);
    }

    public boolean isSort() {
        return this._kind == Kind.Sort;
    }

    public SortProcessor sort() {
        return (SortProcessor)TaggedUnionUtils.get(this, Kind.Sort);
    }

    public boolean isSplit() {
        return this._kind == Kind.Split;
    }

    public SplitProcessor split() {
        return (SplitProcessor)TaggedUnionUtils.get(this, Kind.Split);
    }

    public boolean isTrim() {
        return this._kind == Kind.Trim;
    }

    public TrimProcessor trim() {
        return (TrimProcessor)TaggedUnionUtils.get(this, Kind.Trim);
    }

    public boolean isUppercase() {
        return this._kind == Kind.Uppercase;
    }

    public UppercaseProcessor uppercase() {
        return (UppercaseProcessor)TaggedUnionUtils.get(this, Kind.Uppercase);
    }

    public boolean isUrldecode() {
        return this._kind == Kind.Urldecode;
    }

    public UrlDecodeProcessor urldecode() {
        return (UrlDecodeProcessor)TaggedUnionUtils.get(this, Kind.Urldecode);
    }

    public boolean isUriParts() {
        return this._kind == Kind.UriParts;
    }

    public UriPartsProcessor uriParts() {
        return (UriPartsProcessor)TaggedUnionUtils.get(this, Kind.UriParts);
    }

    public boolean isUserAgent() {
        return this._kind == Kind.UserAgent;
    }

    public UserAgentProcessor userAgent() {
        return (UserAgentProcessor)TaggedUnionUtils.get(this, Kind.UserAgent);
    }

    public boolean _isCustom() {
        return this._kind == Kind._Custom;
    }

    @Override
    @Nullable
    public final String _customKind() {
        return this._customKind;
    }

    public JsonData _custom() {
        return (JsonData)TaggedUnionUtils.get(this, Kind._Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind == Kind._Custom ? this._customKind : this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::append, AppendProcessor._DESERIALIZER, "append");
        op.add(Builder::attachment, AttachmentProcessor._DESERIALIZER, "attachment");
        op.add(Builder::bytes, BytesProcessor._DESERIALIZER, "bytes");
        op.add(Builder::circle, CircleProcessor._DESERIALIZER, "circle");
        op.add(Builder::convert, ConvertProcessor._DESERIALIZER, "convert");
        op.add(Builder::csv, CsvProcessor._DESERIALIZER, "csv");
        op.add(Builder::date, DateProcessor._DESERIALIZER, "date");
        op.add(Builder::dateIndexName, DateIndexNameProcessor._DESERIALIZER, "date_index_name");
        op.add(Builder::dissect, DissectProcessor._DESERIALIZER, "dissect");
        op.add(Builder::dotExpander, DotExpanderProcessor._DESERIALIZER, "dot_expander");
        op.add(Builder::drop, DropProcessor._DESERIALIZER, "drop");
        op.add(Builder::enrich, EnrichProcessor._DESERIALIZER, "enrich");
        op.add(Builder::fail, FailProcessor._DESERIALIZER, "fail");
        op.add(Builder::foreach, ForeachProcessor._DESERIALIZER, "foreach");
        op.add(Builder::geoGrid, GeoGridProcessor._DESERIALIZER, "geo_grid");
        op.add(Builder::geoip, GeoIpProcessor._DESERIALIZER, "geoip");
        op.add(Builder::grok, GrokProcessor._DESERIALIZER, "grok");
        op.add(Builder::gsub, GsubProcessor._DESERIALIZER, "gsub");
        op.add(Builder::htmlStrip, HtmlStripProcessor._DESERIALIZER, "html_strip");
        op.add(Builder::inference, InferenceProcessor._DESERIALIZER, "inference");
        op.add(Builder::join, JoinProcessor._DESERIALIZER, "join");
        op.add(Builder::json, JsonProcessor._DESERIALIZER, "json");
        op.add(Builder::kv, KeyValueProcessor._DESERIALIZER, "kv");
        op.add(Builder::lowercase, LowercaseProcessor._DESERIALIZER, "lowercase");
        op.add(Builder::pipeline, PipelineProcessor._DESERIALIZER, "pipeline");
        op.add(Builder::redact, RedactProcessor._DESERIALIZER, "redact");
        op.add(Builder::remove, RemoveProcessor._DESERIALIZER, "remove");
        op.add(Builder::rename, RenameProcessor._DESERIALIZER, "rename");
        op.add(Builder::reroute, RerouteProcessor._DESERIALIZER, "reroute");
        op.add(Builder::script, ScriptProcessor._DESERIALIZER, "script");
        op.add(Builder::set, SetProcessor._DESERIALIZER, "set");
        op.add(Builder::setSecurityUser, SetSecurityUserProcessor._DESERIALIZER, "set_security_user");
        op.add(Builder::sort, SortProcessor._DESERIALIZER, "sort");
        op.add(Builder::split, SplitProcessor._DESERIALIZER, "split");
        op.add(Builder::trim, TrimProcessor._DESERIALIZER, "trim");
        op.add(Builder::uppercase, UppercaseProcessor._DESERIALIZER, "uppercase");
        op.add(Builder::urldecode, UrlDecodeProcessor._DESERIALIZER, "urldecode");
        op.add(Builder::uriParts, UriPartsProcessor._DESERIALIZER, "uri_parts");
        op.add(Builder::userAgent, UserAgentProcessor._DESERIALIZER, "user_agent");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            JsonpUtils.ensureCustomVariantsAllowed(parser, mapper);
            builder._custom((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Processor> {
        private Kind _kind;
        private Object _value;
        private String _customKind;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Processor> append(AppendProcessor v) {
            this._kind = Kind.Append;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> append(Function<AppendProcessor.Builder, ObjectBuilder<AppendProcessor>> fn) {
            return this.append(fn.apply(new AppendProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> attachment(AttachmentProcessor v) {
            this._kind = Kind.Attachment;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> attachment(Function<AttachmentProcessor.Builder, ObjectBuilder<AttachmentProcessor>> fn) {
            return this.attachment(fn.apply(new AttachmentProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> bytes(BytesProcessor v) {
            this._kind = Kind.Bytes;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> bytes(Function<BytesProcessor.Builder, ObjectBuilder<BytesProcessor>> fn) {
            return this.bytes(fn.apply(new BytesProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> circle(CircleProcessor v) {
            this._kind = Kind.Circle;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> circle(Function<CircleProcessor.Builder, ObjectBuilder<CircleProcessor>> fn) {
            return this.circle(fn.apply(new CircleProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> convert(ConvertProcessor v) {
            this._kind = Kind.Convert;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> convert(Function<ConvertProcessor.Builder, ObjectBuilder<ConvertProcessor>> fn) {
            return this.convert(fn.apply(new ConvertProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> csv(CsvProcessor v) {
            this._kind = Kind.Csv;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> csv(Function<CsvProcessor.Builder, ObjectBuilder<CsvProcessor>> fn) {
            return this.csv(fn.apply(new CsvProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> date(DateProcessor v) {
            this._kind = Kind.Date;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> date(Function<DateProcessor.Builder, ObjectBuilder<DateProcessor>> fn) {
            return this.date(fn.apply(new DateProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> dateIndexName(DateIndexNameProcessor v) {
            this._kind = Kind.DateIndexName;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> dateIndexName(Function<DateIndexNameProcessor.Builder, ObjectBuilder<DateIndexNameProcessor>> fn) {
            return this.dateIndexName(fn.apply(new DateIndexNameProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> dissect(DissectProcessor v) {
            this._kind = Kind.Dissect;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> dissect(Function<DissectProcessor.Builder, ObjectBuilder<DissectProcessor>> fn) {
            return this.dissect(fn.apply(new DissectProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> dotExpander(DotExpanderProcessor v) {
            this._kind = Kind.DotExpander;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> dotExpander(Function<DotExpanderProcessor.Builder, ObjectBuilder<DotExpanderProcessor>> fn) {
            return this.dotExpander(fn.apply(new DotExpanderProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> drop(DropProcessor v) {
            this._kind = Kind.Drop;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> drop(Function<DropProcessor.Builder, ObjectBuilder<DropProcessor>> fn) {
            return this.drop(fn.apply(new DropProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> enrich(EnrichProcessor v) {
            this._kind = Kind.Enrich;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> enrich(Function<EnrichProcessor.Builder, ObjectBuilder<EnrichProcessor>> fn) {
            return this.enrich(fn.apply(new EnrichProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> fail(FailProcessor v) {
            this._kind = Kind.Fail;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> fail(Function<FailProcessor.Builder, ObjectBuilder<FailProcessor>> fn) {
            return this.fail(fn.apply(new FailProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> foreach(ForeachProcessor v) {
            this._kind = Kind.Foreach;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> foreach(Function<ForeachProcessor.Builder, ObjectBuilder<ForeachProcessor>> fn) {
            return this.foreach(fn.apply(new ForeachProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> geoGrid(GeoGridProcessor v) {
            this._kind = Kind.GeoGrid;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> geoGrid(Function<GeoGridProcessor.Builder, ObjectBuilder<GeoGridProcessor>> fn) {
            return this.geoGrid(fn.apply(new GeoGridProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> geoip(GeoIpProcessor v) {
            this._kind = Kind.Geoip;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> geoip(Function<GeoIpProcessor.Builder, ObjectBuilder<GeoIpProcessor>> fn) {
            return this.geoip(fn.apply(new GeoIpProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> grok(GrokProcessor v) {
            this._kind = Kind.Grok;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> grok(Function<GrokProcessor.Builder, ObjectBuilder<GrokProcessor>> fn) {
            return this.grok(fn.apply(new GrokProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> gsub(GsubProcessor v) {
            this._kind = Kind.Gsub;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> gsub(Function<GsubProcessor.Builder, ObjectBuilder<GsubProcessor>> fn) {
            return this.gsub(fn.apply(new GsubProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> htmlStrip(HtmlStripProcessor v) {
            this._kind = Kind.HtmlStrip;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> htmlStrip(Function<HtmlStripProcessor.Builder, ObjectBuilder<HtmlStripProcessor>> fn) {
            return this.htmlStrip(fn.apply(new HtmlStripProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> inference(InferenceProcessor v) {
            this._kind = Kind.Inference;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> inference(Function<InferenceProcessor.Builder, ObjectBuilder<InferenceProcessor>> fn) {
            return this.inference(fn.apply(new InferenceProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> join(JoinProcessor v) {
            this._kind = Kind.Join;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> join(Function<JoinProcessor.Builder, ObjectBuilder<JoinProcessor>> fn) {
            return this.join(fn.apply(new JoinProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> json(JsonProcessor v) {
            this._kind = Kind.Json;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> json(Function<JsonProcessor.Builder, ObjectBuilder<JsonProcessor>> fn) {
            return this.json(fn.apply(new JsonProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> kv(KeyValueProcessor v) {
            this._kind = Kind.Kv;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> kv(Function<KeyValueProcessor.Builder, ObjectBuilder<KeyValueProcessor>> fn) {
            return this.kv(fn.apply(new KeyValueProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> lowercase(LowercaseProcessor v) {
            this._kind = Kind.Lowercase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> lowercase(Function<LowercaseProcessor.Builder, ObjectBuilder<LowercaseProcessor>> fn) {
            return this.lowercase(fn.apply(new LowercaseProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> pipeline(PipelineProcessor v) {
            this._kind = Kind.Pipeline;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> pipeline(Function<PipelineProcessor.Builder, ObjectBuilder<PipelineProcessor>> fn) {
            return this.pipeline(fn.apply(new PipelineProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> redact(RedactProcessor v) {
            this._kind = Kind.Redact;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> redact(Function<RedactProcessor.Builder, ObjectBuilder<RedactProcessor>> fn) {
            return this.redact(fn.apply(new RedactProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> remove(RemoveProcessor v) {
            this._kind = Kind.Remove;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> remove(Function<RemoveProcessor.Builder, ObjectBuilder<RemoveProcessor>> fn) {
            return this.remove(fn.apply(new RemoveProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> rename(RenameProcessor v) {
            this._kind = Kind.Rename;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> rename(Function<RenameProcessor.Builder, ObjectBuilder<RenameProcessor>> fn) {
            return this.rename(fn.apply(new RenameProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> reroute(RerouteProcessor v) {
            this._kind = Kind.Reroute;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> reroute(Function<RerouteProcessor.Builder, ObjectBuilder<RerouteProcessor>> fn) {
            return this.reroute(fn.apply(new RerouteProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> script(ScriptProcessor v) {
            this._kind = Kind.Script;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> script(Function<ScriptProcessor.Builder, ObjectBuilder<ScriptProcessor>> fn) {
            return this.script(fn.apply(new ScriptProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> set(SetProcessor v) {
            this._kind = Kind.Set;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> set(Function<SetProcessor.Builder, ObjectBuilder<SetProcessor>> fn) {
            return this.set(fn.apply(new SetProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> setSecurityUser(SetSecurityUserProcessor v) {
            this._kind = Kind.SetSecurityUser;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> setSecurityUser(Function<SetSecurityUserProcessor.Builder, ObjectBuilder<SetSecurityUserProcessor>> fn) {
            return this.setSecurityUser(fn.apply(new SetSecurityUserProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> sort(SortProcessor v) {
            this._kind = Kind.Sort;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> sort(Function<SortProcessor.Builder, ObjectBuilder<SortProcessor>> fn) {
            return this.sort(fn.apply(new SortProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> split(SplitProcessor v) {
            this._kind = Kind.Split;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> split(Function<SplitProcessor.Builder, ObjectBuilder<SplitProcessor>> fn) {
            return this.split(fn.apply(new SplitProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> trim(TrimProcessor v) {
            this._kind = Kind.Trim;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> trim(Function<TrimProcessor.Builder, ObjectBuilder<TrimProcessor>> fn) {
            return this.trim(fn.apply(new TrimProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> uppercase(UppercaseProcessor v) {
            this._kind = Kind.Uppercase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> uppercase(Function<UppercaseProcessor.Builder, ObjectBuilder<UppercaseProcessor>> fn) {
            return this.uppercase(fn.apply(new UppercaseProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> urldecode(UrlDecodeProcessor v) {
            this._kind = Kind.Urldecode;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> urldecode(Function<UrlDecodeProcessor.Builder, ObjectBuilder<UrlDecodeProcessor>> fn) {
            return this.urldecode(fn.apply(new UrlDecodeProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> uriParts(UriPartsProcessor v) {
            this._kind = Kind.UriParts;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> uriParts(Function<UriPartsProcessor.Builder, ObjectBuilder<UriPartsProcessor>> fn) {
            return this.uriParts(fn.apply(new UriPartsProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> userAgent(UserAgentProcessor v) {
            this._kind = Kind.UserAgent;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Processor> userAgent(Function<UserAgentProcessor.Builder, ObjectBuilder<UserAgentProcessor>> fn) {
            return this.userAgent(fn.apply(new UserAgentProcessor.Builder()).build());
        }

        public ObjectBuilder<Processor> _custom(String name, Object data) {
            this._kind = Kind._Custom;
            this._customKind = name;
            this._value = JsonData.of(data);
            return this;
        }

        @Override
        public Processor build() {
            this._checkSingleUse();
            return new Processor(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Append("append"),
        Attachment("attachment"),
        Bytes("bytes"),
        Circle("circle"),
        Convert("convert"),
        Csv("csv"),
        Date("date"),
        DateIndexName("date_index_name"),
        Dissect("dissect"),
        DotExpander("dot_expander"),
        Drop("drop"),
        Enrich("enrich"),
        Fail("fail"),
        Foreach("foreach"),
        GeoGrid("geo_grid"),
        Geoip("geoip"),
        Grok("grok"),
        Gsub("gsub"),
        HtmlStrip("html_strip"),
        Inference("inference"),
        Join("join"),
        Json("json"),
        Kv("kv"),
        Lowercase("lowercase"),
        Pipeline("pipeline"),
        Redact("redact"),
        Remove("remove"),
        Rename("rename"),
        Reroute("reroute"),
        Script("script"),
        Set("set"),
        SetSecurityUser("set_security_user"),
        Sort("sort"),
        Split("split"),
        Trim("trim"),
        Uppercase("uppercase"),
        Urldecode("urldecode"),
        UriParts("uri_parts"),
        UserAgent("user_agent"),
        _Custom(null);

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

