/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMappingException;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.QuadConsumer;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ObjectDeserializer<ObjectType>
implements JsonpDeserializer<ObjectType> {
    private static final FieldDeserializer<?> IGNORED_FIELD = new FieldDeserializer<Object>("-"){

        @Override
        public void deserialize(JsonParser parser, JsonpMapper mapper, String fieldName, Object object) {
            JsonpUtils.skipValue(parser);
        }

        @Override
        public void deserialize(JsonParser parser, JsonpMapper mapper, String fieldName, Object object, JsonParser.Event event) {
            JsonpUtils.skipValue(parser, event);
        }

        @Override
        public EnumSet<JsonParser.Event> acceptedEvents() {
            return EnumSet.allOf(JsonParser.Event.class);
        }
    };
    private static final EnumSet<JsonParser.Event> EventSetObject = EnumSet.of(JsonParser.Event.START_OBJECT, JsonParser.Event.KEY_NAME);
    private static final EnumSet<JsonParser.Event> EventSetObjectAndString = EnumSet.of(JsonParser.Event.START_OBJECT, JsonParser.Event.VALUE_STRING, JsonParser.Event.KEY_NAME);
    private EnumSet<JsonParser.Event> acceptedEvents = EventSetObject;
    private final Supplier<ObjectType> constructor;
    protected final Map<String, FieldDeserializer<ObjectType>> fieldDeserializers;
    private FieldDeserializer<ObjectType> singleKey;
    private String typeProperty;
    private String defaultType;
    private FieldDeserializer<ObjectType> shortcutProperty;
    private QuadConsumer<ObjectType, String, JsonParser, JsonpMapper> unknownFieldHandler;

    public ObjectDeserializer(Supplier<ObjectType> constructor) {
        this.constructor = constructor;
        this.fieldDeserializers = new HashMap<String, FieldDeserializer<ObjectType>>();
    }

    public Set<String> fieldNames() {
        return Collections.unmodifiableSet(this.fieldDeserializers.keySet());
    }

    @Nullable
    public String shortcutProperty() {
        return this.shortcutProperty == null ? null : this.shortcutProperty.name;
    }

    @Override
    public EnumSet<JsonParser.Event> nativeEvents() {
        return this.acceptedEvents;
    }

    @Override
    public EnumSet<JsonParser.Event> acceptedEvents() {
        return this.acceptedEvents;
    }

    @Override
    public ObjectType deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        return this.deserialize(this.constructor.get(), parser, mapper, event);
    }

    public ObjectType deserialize(ObjectType value, JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        if (event == JsonParser.Event.VALUE_NULL) {
            return null;
        }
        String keyName = null;
        String fieldName = null;
        try {
            if (this.singleKey != null) {
                if (event == JsonParser.Event.START_OBJECT) {
                    event = JsonpUtils.expectNextEvent(parser, JsonParser.Event.KEY_NAME);
                }
                this.singleKey.deserialize(parser, mapper, null, value, event);
                event = parser.next();
            }
            if (this.shortcutProperty != null && event != JsonParser.Event.START_OBJECT && event != JsonParser.Event.KEY_NAME) {
                this.shortcutProperty.deserialize(parser, mapper, this.shortcutProperty.name, value, event);
            } else if (this.typeProperty == null) {
                if (event != JsonParser.Event.START_OBJECT && event != JsonParser.Event.KEY_NAME) {
                    JsonpUtils.expectEvent(parser, JsonParser.Event.START_OBJECT, event);
                }
                if (event == JsonParser.Event.START_OBJECT) {
                    event = parser.next();
                }
                while (event != JsonParser.Event.END_OBJECT) {
                    JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
                    fieldName = parser.getString();
                    FieldDeserializer<ObjectType> fieldDeserializer = this.fieldDeserializers.get(fieldName);
                    if (fieldDeserializer == null) {
                        this.parseUnknownField(parser, mapper, fieldName, value);
                    } else {
                        fieldDeserializer.deserialize(parser, mapper, fieldName, value);
                    }
                    event = parser.next();
                }
                fieldName = null;
            } else {
                JsonpUtils.expectEvent(parser, JsonParser.Event.START_OBJECT, event);
                Map.Entry<String, JsonParser> unionInfo = JsonpUtils.lookAheadFieldValue(this.typeProperty, this.defaultType, parser, mapper);
                String variant = unionInfo.getKey();
                JsonParser innerParser = unionInfo.getValue();
                FieldDeserializer<ObjectType> fieldDeserializer = this.fieldDeserializers.get(variant);
                if (fieldDeserializer == null) {
                    this.parseUnknownField(innerParser, mapper, variant, value);
                } else {
                    fieldDeserializer.deserialize(innerParser, mapper, variant, value);
                }
            }
            if (this.singleKey != null) {
                JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
            }
        }
        catch (Exception e) {
            throw JsonpMappingException.from(e, value, fieldName, parser).prepend(value, keyName);
        }
        return value;
    }

    protected void parseUnknownField(JsonParser parser, JsonpMapper mapper, String fieldName, ObjectType object) {
        if (this.unknownFieldHandler != null) {
            this.unknownFieldHandler.accept(object, fieldName, parser, mapper);
        } else if (mapper.ignoreUnknownFields()) {
            JsonpUtils.skipValue(parser);
        } else {
            throw new JsonpMappingException("Unknown field '" + fieldName + "'", parser.getLocation());
        }
    }

    public void setUnknownFieldHandler(QuadConsumer<ObjectType, String, JsonParser, JsonpMapper> unknownFieldHandler) {
        this.unknownFieldHandler = unknownFieldHandler;
    }

    public void ignore(String name) {
        this.fieldDeserializers.put(name, IGNORED_FIELD);
    }

    public void shortcutProperty(String name) {
        this.shortcutProperty = this.fieldDeserializers.get(name);
        if (this.shortcutProperty == null) {
            throw new NoSuchElementException("No deserializer was setup for '" + name + "'");
        }
        this.acceptedEvents = EventSetObjectAndString;
    }

    public <FieldType> void add(BiConsumer<ObjectType, FieldType> setter, JsonpDeserializer<FieldType> deserializer, String name) {
        FieldObjectDeserializer<ObjectType, FieldType> fieldDeserializer = new FieldObjectDeserializer<ObjectType, FieldType>(setter, deserializer, name);
        this.fieldDeserializers.put(name, fieldDeserializer);
    }

    public <FieldType> void add(BiConsumer<ObjectType, FieldType> setter, JsonpDeserializer<FieldType> deserializer, String name, String ... aliases) {
        FieldObjectDeserializer<ObjectType, FieldType> fieldDeserializer = new FieldObjectDeserializer<ObjectType, FieldType>(setter, deserializer, name);
        this.fieldDeserializers.put(name, fieldDeserializer);
        for (String alias : aliases) {
            this.fieldDeserializers.put(alias, fieldDeserializer);
        }
    }

    public <FieldType> void setKey(BiConsumer<ObjectType, FieldType> setter, JsonpDeserializer<FieldType> deserializer) {
        this.singleKey = new FieldObjectDeserializer<ObjectType, FieldType>(setter, deserializer, null);
    }

    public void setTypeProperty(String name, String defaultType) {
        this.typeProperty = name;
        this.defaultType = defaultType;
        if (this.unknownFieldHandler == null) {
            this.unknownFieldHandler = (o, value, parser, mapper) -> {
                throw new JsonpMappingException("Unknown '" + name + "' value: '" + value + "'", parser.getLocation());
            };
        }
    }

    public void add(ObjIntConsumer<ObjectType> setter, String name, String ... deprecatedNames) {
        this.add(setter::accept, JsonpDeserializer.integerDeserializer(), name, deprecatedNames);
    }

    public static abstract class FieldDeserializer<ObjectType> {
        protected final String name;

        public FieldDeserializer(String name) {
            this.name = name;
        }

        public abstract EnumSet<JsonParser.Event> acceptedEvents();

        public abstract void deserialize(JsonParser var1, JsonpMapper var2, String var3, ObjectType var4);

        public abstract void deserialize(JsonParser var1, JsonpMapper var2, String var3, ObjectType var4, JsonParser.Event var5);
    }

    public static class FieldObjectDeserializer<ObjectType, FieldType>
    extends FieldDeserializer<ObjectType> {
        private final BiConsumer<ObjectType, FieldType> setter;
        private final JsonpDeserializer<FieldType> deserializer;

        public FieldObjectDeserializer(BiConsumer<ObjectType, FieldType> setter, JsonpDeserializer<FieldType> deserializer, String name) {
            super(name);
            this.setter = setter;
            this.deserializer = deserializer;
        }

        public String name() {
            return this.name;
        }

        @Override
        public EnumSet<JsonParser.Event> acceptedEvents() {
            return this.deserializer.acceptedEvents();
        }

        @Override
        public void deserialize(JsonParser parser, JsonpMapper mapper, String fieldName, ObjectType object) {
            FieldType fieldValue = this.deserializer.deserialize(parser, mapper);
            this.setter.accept(object, fieldValue);
        }

        @Override
        public void deserialize(JsonParser parser, JsonpMapper mapper, String fieldName, ObjectType object, JsonParser.Event event) {
            JsonpUtils.ensureAccepts(this.deserializer, parser, event);
            FieldType fieldValue = this.deserializer.deserialize(parser, mapper, event);
            this.setter.accept(object, fieldValue);
        }
    }
}

