/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.ModelConfig;
import co.elastic.clients.elasticsearch.inference.TaskType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ModelConfigContainer
extends ModelConfig {
    private final String modelId;
    private final TaskType taskType;
    public static final JsonpDeserializer<ModelConfigContainer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ModelConfigContainer::setupModelConfigContainerDeserializer);

    protected ModelConfigContainer(AbstractBuilder<?> builder) {
        super(builder);
        this.modelId = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).modelId, this, "modelId");
        this.taskType = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).taskType, this, "taskType");
    }

    public static ModelConfigContainer modelConfigContainerOf(Function<Builder, ObjectBuilder<ModelConfigContainer>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelId() {
        return this.modelId;
    }

    public final TaskType taskType() {
        return this.taskType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("task_type");
        this.taskType.serialize(generator, mapper);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupModelConfigContainerDeserializer(ObjectDeserializer<BuilderT> op) {
        ModelConfig.setupModelConfigDeserializer(op);
        op.add(AbstractBuilder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(AbstractBuilder::taskType, TaskType._DESERIALIZER, "task_type");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ModelConfig.AbstractBuilder<BuilderT> {
        private String modelId;
        private TaskType taskType;

        public final BuilderT modelId(String value) {
            this.modelId = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT taskType(TaskType value) {
            this.taskType = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<ModelConfigContainer> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ModelConfigContainer build() {
            this._checkSingleUse();
            return new ModelConfigContainer(this);
        }
    }
}

