/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JobTimingStats
implements JsonpSerializable {
    @Nullable
    private final Double averageBucketProcessingTimeMs;
    private final long bucketCount;
    @Nullable
    private final Double exponentialAverageBucketProcessingTimeMs;
    private final double exponentialAverageBucketProcessingTimePerHourMs;
    private final String jobId;
    private final double totalBucketProcessingTimeMs;
    @Nullable
    private final Double maximumBucketProcessingTimeMs;
    @Nullable
    private final Double minimumBucketProcessingTimeMs;
    public static final JsonpDeserializer<JobTimingStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JobTimingStats::setupJobTimingStatsDeserializer);

    private JobTimingStats(Builder builder) {
        this.averageBucketProcessingTimeMs = builder.averageBucketProcessingTimeMs;
        this.bucketCount = ApiTypeHelper.requireNonNull(builder.bucketCount, this, "bucketCount");
        this.exponentialAverageBucketProcessingTimeMs = builder.exponentialAverageBucketProcessingTimeMs;
        this.exponentialAverageBucketProcessingTimePerHourMs = ApiTypeHelper.requireNonNull(builder.exponentialAverageBucketProcessingTimePerHourMs, this, "exponentialAverageBucketProcessingTimePerHourMs");
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.totalBucketProcessingTimeMs = ApiTypeHelper.requireNonNull(builder.totalBucketProcessingTimeMs, this, "totalBucketProcessingTimeMs");
        this.maximumBucketProcessingTimeMs = builder.maximumBucketProcessingTimeMs;
        this.minimumBucketProcessingTimeMs = builder.minimumBucketProcessingTimeMs;
    }

    public static JobTimingStats of(Function<Builder, ObjectBuilder<JobTimingStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double averageBucketProcessingTimeMs() {
        return this.averageBucketProcessingTimeMs;
    }

    public final long bucketCount() {
        return this.bucketCount;
    }

    @Nullable
    public final Double exponentialAverageBucketProcessingTimeMs() {
        return this.exponentialAverageBucketProcessingTimeMs;
    }

    public final double exponentialAverageBucketProcessingTimePerHourMs() {
        return this.exponentialAverageBucketProcessingTimePerHourMs;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final double totalBucketProcessingTimeMs() {
        return this.totalBucketProcessingTimeMs;
    }

    @Nullable
    public final Double maximumBucketProcessingTimeMs() {
        return this.maximumBucketProcessingTimeMs;
    }

    @Nullable
    public final Double minimumBucketProcessingTimeMs() {
        return this.minimumBucketProcessingTimeMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.averageBucketProcessingTimeMs != null) {
            generator.writeKey("average_bucket_processing_time_ms");
            generator.write(this.averageBucketProcessingTimeMs.doubleValue());
        }
        generator.writeKey("bucket_count");
        generator.write(this.bucketCount);
        if (this.exponentialAverageBucketProcessingTimeMs != null) {
            generator.writeKey("exponential_average_bucket_processing_time_ms");
            generator.write(this.exponentialAverageBucketProcessingTimeMs.doubleValue());
        }
        generator.writeKey("exponential_average_bucket_processing_time_per_hour_ms");
        generator.write(this.exponentialAverageBucketProcessingTimePerHourMs);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("total_bucket_processing_time_ms");
        generator.write(this.totalBucketProcessingTimeMs);
        if (this.maximumBucketProcessingTimeMs != null) {
            generator.writeKey("maximum_bucket_processing_time_ms");
            generator.write(this.maximumBucketProcessingTimeMs.doubleValue());
        }
        if (this.minimumBucketProcessingTimeMs != null) {
            generator.writeKey("minimum_bucket_processing_time_ms");
            generator.write(this.minimumBucketProcessingTimeMs.doubleValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupJobTimingStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::averageBucketProcessingTimeMs, JsonpDeserializer.doubleDeserializer(), "average_bucket_processing_time_ms");
        op.add(Builder::bucketCount, JsonpDeserializer.longDeserializer(), "bucket_count");
        op.add(Builder::exponentialAverageBucketProcessingTimeMs, JsonpDeserializer.doubleDeserializer(), "exponential_average_bucket_processing_time_ms");
        op.add(Builder::exponentialAverageBucketProcessingTimePerHourMs, JsonpDeserializer.doubleDeserializer(), "exponential_average_bucket_processing_time_per_hour_ms");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::totalBucketProcessingTimeMs, JsonpDeserializer.doubleDeserializer(), "total_bucket_processing_time_ms");
        op.add(Builder::maximumBucketProcessingTimeMs, JsonpDeserializer.doubleDeserializer(), "maximum_bucket_processing_time_ms");
        op.add(Builder::minimumBucketProcessingTimeMs, JsonpDeserializer.doubleDeserializer(), "minimum_bucket_processing_time_ms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<JobTimingStats> {
        @Nullable
        private Double averageBucketProcessingTimeMs;
        private Long bucketCount;
        @Nullable
        private Double exponentialAverageBucketProcessingTimeMs;
        private Double exponentialAverageBucketProcessingTimePerHourMs;
        private String jobId;
        private Double totalBucketProcessingTimeMs;
        @Nullable
        private Double maximumBucketProcessingTimeMs;
        @Nullable
        private Double minimumBucketProcessingTimeMs;

        public final Builder averageBucketProcessingTimeMs(@Nullable Double value) {
            this.averageBucketProcessingTimeMs = value;
            return this;
        }

        public final Builder bucketCount(long value) {
            this.bucketCount = value;
            return this;
        }

        public final Builder exponentialAverageBucketProcessingTimeMs(@Nullable Double value) {
            this.exponentialAverageBucketProcessingTimeMs = value;
            return this;
        }

        public final Builder exponentialAverageBucketProcessingTimePerHourMs(double value) {
            this.exponentialAverageBucketProcessingTimePerHourMs = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder totalBucketProcessingTimeMs(double value) {
            this.totalBucketProcessingTimeMs = value;
            return this;
        }

        public final Builder maximumBucketProcessingTimeMs(@Nullable Double value) {
            this.maximumBucketProcessingTimeMs = value;
            return this;
        }

        public final Builder minimumBucketProcessingTimeMs(@Nullable Double value) {
            this.minimumBucketProcessingTimeMs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JobTimingStats build() {
            this._checkSingleUse();
            return new JobTimingStats(this);
        }
    }
}

