/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.autoscaling;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class AutoscalingPolicy
implements JsonpSerializable {
    private final List<String> roles;
    private final Map<String, JsonData> deciders;
    public static final JsonpDeserializer<AutoscalingPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoscalingPolicy::setupAutoscalingPolicyDeserializer);

    protected AutoscalingPolicy(AbstractBuilder<?> builder) {
        this.roles = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).roles, (Object)this, "roles");
        this.deciders = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).deciders, (Object)this, "deciders");
    }

    public static AutoscalingPolicy autoscalingPolicyOf(Function<Builder, ObjectBuilder<AutoscalingPolicy>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> roles() {
        return this.roles;
    }

    public final Map<String, JsonData> deciders() {
        return this.deciders;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.deciders)) {
            generator.writeKey("deciders");
            generator.writeStartObject();
            for (Map.Entry entry : this.deciders.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAutoscalingPolicyDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(AbstractBuilder::deciders, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "deciders");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private List<String> roles;
        private Map<String, JsonData> deciders;

        public final BuilderT roles(List<String> list) {
            this.roles = AbstractBuilder._listAddAll(this.roles, list);
            return (BuilderT)this.self();
        }

        public final BuilderT roles(String value, String ... values) {
            this.roles = AbstractBuilder._listAdd(this.roles, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT deciders(Map<String, JsonData> map) {
            this.deciders = AbstractBuilder._mapPutAll(this.deciders, map);
            return (BuilderT)this.self();
        }

        public final BuilderT deciders(String key, JsonData value) {
            this.deciders = AbstractBuilder._mapPut(this.deciders, key, value);
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<AutoscalingPolicy> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AutoscalingPolicy build() {
            this._checkSingleUse();
            return new AutoscalingPolicy(this);
        }
    }
}

