/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.elasticsearch.ingest.UserAgentProperty;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UserAgentProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    private final List<UserAgentProperty> options;
    @Nullable
    private final String regexFile;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<UserAgentProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UserAgentProcessor::setupUserAgentProcessorDeserializer);

    private UserAgentProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.options = ApiTypeHelper.unmodifiable(builder.options);
        this.regexFile = builder.regexFile;
        this.targetField = builder.targetField;
    }

    public static UserAgentProcessor of(Function<Builder, ObjectBuilder<UserAgentProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.UserAgent;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final List<UserAgentProperty> options() {
        return this.options;
    }

    @Nullable
    public final String regexFile() {
        return this.regexFile;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartArray();
            for (UserAgentProperty item0 : this.options) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.regexFile != null) {
            generator.writeKey("regex_file");
            generator.write(this.regexFile);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    protected static void setupUserAgentProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::options, JsonpDeserializer.arrayDeserializer(UserAgentProperty._DESERIALIZER), "options");
        op.add(Builder::regexFile, JsonpDeserializer.stringDeserializer(), "regex_file");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UserAgentProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private List<UserAgentProperty> options;
        @Nullable
        private String regexFile;
        @Nullable
        private String targetField;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder options(List<UserAgentProperty> list) {
            this.options = Builder._listAddAll(this.options, list);
            return this;
        }

        public final Builder options(UserAgentProperty value, UserAgentProperty ... values) {
            this.options = Builder._listAdd(this.options, value, values);
            return this;
        }

        public final Builder regexFile(@Nullable String value) {
            this.regexFile = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UserAgentProcessor build() {
            this._checkSingleUse();
            return new UserAgentProcessor(this);
        }
    }
}

