/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PreviewDataFrameAnalyticsResponse;
import co.elastic.clients.elasticsearch.ml.preview_data_frame_analytics.DataframePreviewConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PreviewDataFrameAnalyticsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final DataframePreviewConfig config;
    @Nullable
    private final String id;
    public static final JsonpDeserializer<PreviewDataFrameAnalyticsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PreviewDataFrameAnalyticsRequest::setupPreviewDataFrameAnalyticsRequestDeserializer);
    public static final Endpoint<PreviewDataFrameAnalyticsRequest, PreviewDataFrameAnalyticsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PreviewDataFrameAnalyticsRequest, PreviewDataFrameAnalyticsResponse>("es/ml.preview_data_frame_analytics", request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/_preview");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_preview");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("id", request.id);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PreviewDataFrameAnalyticsResponse._DESERIALIZER);

    private PreviewDataFrameAnalyticsRequest(Builder builder) {
        this.config = builder.config;
        this.id = builder.id;
    }

    public static PreviewDataFrameAnalyticsRequest of(Function<Builder, ObjectBuilder<PreviewDataFrameAnalyticsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DataframePreviewConfig config() {
        return this.config;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.config != null) {
            generator.writeKey("config");
            this.config.serialize(generator, mapper);
        }
    }

    protected static void setupPreviewDataFrameAnalyticsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::config, DataframePreviewConfig._DESERIALIZER, "config");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PreviewDataFrameAnalyticsRequest> {
        @Nullable
        private DataframePreviewConfig config;
        @Nullable
        private String id;

        public final Builder config(@Nullable DataframePreviewConfig value) {
            this.config = value;
            return this;
        }

        public final Builder config(Function<DataframePreviewConfig.Builder, ObjectBuilder<DataframePreviewConfig>> fn) {
            return this.config(fn.apply(new DataframePreviewConfig.Builder()).build());
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PreviewDataFrameAnalyticsRequest build() {
            this._checkSingleUse();
            return new PreviewDataFrameAnalyticsRequest(this);
        }
    }
}

