/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.watcher.DailySchedule;
import co.elastic.clients.elasticsearch.watcher.HourlySchedule;
import co.elastic.clients.elasticsearch.watcher.ScheduleVariant;
import co.elastic.clients.elasticsearch.watcher.TimeOfMonth;
import co.elastic.clients.elasticsearch.watcher.TimeOfWeek;
import co.elastic.clients.elasticsearch.watcher.TimeOfYear;
import co.elastic.clients.elasticsearch.watcher.Trigger;
import co.elastic.clients.elasticsearch.watcher.TriggerVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Schedule
implements TaggedUnion<Kind, Object>,
TriggerVariant,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Schedule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Schedule::setupScheduleDeserializer, Builder::build);

    @Override
    public Trigger.Kind _triggerKind() {
        return Trigger.Kind.Schedule;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Schedule(ScheduleVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._scheduleKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Schedule(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Schedule of(Function<Builder, ObjectBuilder<Schedule>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCron() {
        return this._kind == Kind.Cron;
    }

    public String cron() {
        return (String)TaggedUnionUtils.get(this, Kind.Cron);
    }

    public boolean isDaily() {
        return this._kind == Kind.Daily;
    }

    public DailySchedule daily() {
        return (DailySchedule)TaggedUnionUtils.get(this, Kind.Daily);
    }

    public boolean isHourly() {
        return this._kind == Kind.Hourly;
    }

    public HourlySchedule hourly() {
        return (HourlySchedule)TaggedUnionUtils.get(this, Kind.Hourly);
    }

    public boolean isInterval() {
        return this._kind == Kind.Interval;
    }

    public Time interval() {
        return (Time)TaggedUnionUtils.get(this, Kind.Interval);
    }

    public boolean isMonthly() {
        return this._kind == Kind.Monthly;
    }

    public List<TimeOfMonth> monthly() {
        return (List)TaggedUnionUtils.get(this, Kind.Monthly);
    }

    public boolean isWeekly() {
        return this._kind == Kind.Weekly;
    }

    public List<TimeOfWeek> weekly() {
        return (List)TaggedUnionUtils.get(this, Kind.Weekly);
    }

    public boolean isYearly() {
        return this._kind == Kind.Yearly;
    }

    public List<TimeOfYear> yearly() {
        return (List)TaggedUnionUtils.get(this, Kind.Yearly);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Cron: {
                    generator.write((String)this._value);
                    break;
                }
                case Monthly: {
                    generator.writeStartArray();
                    for (TimeOfMonth item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case Weekly: {
                    generator.writeStartArray();
                    for (TimeOfWeek item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case Yearly: {
                    generator.writeStartArray();
                    for (TimeOfYear item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupScheduleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cron, JsonpDeserializer.stringDeserializer(), "cron");
        op.add(Builder::daily, DailySchedule._DESERIALIZER, "daily");
        op.add(Builder::hourly, HourlySchedule._DESERIALIZER, "hourly");
        op.add(Builder::interval, Time._DESERIALIZER, "interval");
        op.add(Builder::monthly, JsonpDeserializer.arrayDeserializer(TimeOfMonth._DESERIALIZER), "monthly");
        op.add(Builder::weekly, JsonpDeserializer.arrayDeserializer(TimeOfWeek._DESERIALIZER), "weekly");
        op.add(Builder::yearly, JsonpDeserializer.arrayDeserializer(TimeOfYear._DESERIALIZER), "yearly");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Schedule> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Schedule> cron(String v) {
            this._kind = Kind.Cron;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Schedule> daily(DailySchedule v) {
            this._kind = Kind.Daily;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Schedule> daily(Function<DailySchedule.Builder, ObjectBuilder<DailySchedule>> fn) {
            return this.daily(fn.apply(new DailySchedule.Builder()).build());
        }

        public ObjectBuilder<Schedule> hourly(HourlySchedule v) {
            this._kind = Kind.Hourly;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Schedule> hourly(Function<HourlySchedule.Builder, ObjectBuilder<HourlySchedule>> fn) {
            return this.hourly(fn.apply(new HourlySchedule.Builder()).build());
        }

        public ObjectBuilder<Schedule> interval(Time v) {
            this._kind = Kind.Interval;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Schedule> interval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.interval(fn.apply(new Time.Builder()).build());
        }

        public ObjectBuilder<Schedule> monthly(List<TimeOfMonth> v) {
            this._kind = Kind.Monthly;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Schedule> weekly(List<TimeOfWeek> v) {
            this._kind = Kind.Weekly;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Schedule> yearly(List<TimeOfYear> v) {
            this._kind = Kind.Yearly;
            this._value = v;
            return this;
        }

        @Override
        public Schedule build() {
            this._checkSingleUse();
            return new Schedule(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Cron("cron"),
        Daily("daily"),
        Hourly("hourly"),
        Interval("interval"),
        Monthly("monthly"),
        Weekly("weekly"),
        Yearly("yearly");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

