/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Destination
implements JsonpSerializable {
    @Nullable
    private final String index;
    @Nullable
    private final String pipeline;
    public static final JsonpDeserializer<Destination> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Destination::setupDestinationDeserializer);

    private Destination(Builder builder) {
        this.index = builder.index;
        this.pipeline = builder.pipeline;
    }

    public static Destination of(Function<Builder, ObjectBuilder<Destination>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            generator.write(this.pipeline);
        }
    }

    protected static void setupDestinationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Destination> {
        @Nullable
        private String index;
        @Nullable
        private String pipeline;

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Destination build() {
            this._checkSingleUse();
            return new Destination(this);
        }
    }
}

