/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.searchable_snapshots.mount;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class MountedSnapshot
implements JsonpSerializable {
    private final String snapshot;
    private final List<String> indices;
    private final ShardStatistics shards;
    public static final JsonpDeserializer<MountedSnapshot> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MountedSnapshot::setupMountedSnapshotDeserializer);

    private MountedSnapshot(Builder builder) {
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
    }

    public static MountedSnapshot of(Function<Builder, ObjectBuilder<MountedSnapshot>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String snapshot() {
        return this.snapshot;
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("snapshot");
        generator.write(this.snapshot);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("shards");
        this.shards.serialize(generator, mapper);
    }

    protected static void setupMountedSnapshotDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "shards");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MountedSnapshot> {
        private String snapshot;
        private List<String> indices;
        private ShardStatistics shards;

        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MountedSnapshot build() {
            this._checkSingleUse();
            return new MountedSnapshot(this);
        }
    }
}

