/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.ConfusionMatrixThreshold;
import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeEvaluationSummaryAucRoc;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeOutlierDetectionSummary
implements JsonpSerializable {
    @Nullable
    private final DataframeEvaluationSummaryAucRoc aucRoc;
    private final Map<String, Double> precision;
    private final Map<String, Double> recall;
    private final Map<String, ConfusionMatrixThreshold> confusionMatrix;
    public static final JsonpDeserializer<DataframeOutlierDetectionSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeOutlierDetectionSummary::setupDataframeOutlierDetectionSummaryDeserializer);

    private DataframeOutlierDetectionSummary(Builder builder) {
        this.aucRoc = builder.aucRoc;
        this.precision = ApiTypeHelper.unmodifiable(builder.precision);
        this.recall = ApiTypeHelper.unmodifiable(builder.recall);
        this.confusionMatrix = ApiTypeHelper.unmodifiable(builder.confusionMatrix);
    }

    public static DataframeOutlierDetectionSummary of(Function<Builder, ObjectBuilder<DataframeOutlierDetectionSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DataframeEvaluationSummaryAucRoc aucRoc() {
        return this.aucRoc;
    }

    public final Map<String, Double> precision() {
        return this.precision;
    }

    public final Map<String, Double> recall() {
        return this.recall;
    }

    public final Map<String, ConfusionMatrixThreshold> confusionMatrix() {
        return this.confusionMatrix;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aucRoc != null) {
            generator.writeKey("auc_roc");
            this.aucRoc.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.precision)) {
            generator.writeKey("precision");
            generator.writeStartObject();
            for (Map.Entry<String, Double> entry : this.precision.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().doubleValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.recall)) {
            generator.writeKey("recall");
            generator.writeStartObject();
            for (Map.Entry<String, Double> entry : this.recall.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().doubleValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.confusionMatrix)) {
            generator.writeKey("confusion_matrix");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.confusionMatrix.entrySet()) {
                generator.writeKey(entry.getKey());
                ((ConfusionMatrixThreshold)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDataframeOutlierDetectionSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aucRoc, DataframeEvaluationSummaryAucRoc._DESERIALIZER, "auc_roc");
        op.add(Builder::precision, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "precision");
        op.add(Builder::recall, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "recall");
        op.add(Builder::confusionMatrix, JsonpDeserializer.stringMapDeserializer(ConfusionMatrixThreshold._DESERIALIZER), "confusion_matrix");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeOutlierDetectionSummary> {
        @Nullable
        private DataframeEvaluationSummaryAucRoc aucRoc;
        @Nullable
        private Map<String, Double> precision;
        @Nullable
        private Map<String, Double> recall;
        @Nullable
        private Map<String, ConfusionMatrixThreshold> confusionMatrix;

        public final Builder aucRoc(@Nullable DataframeEvaluationSummaryAucRoc value) {
            this.aucRoc = value;
            return this;
        }

        public final Builder aucRoc(Function<DataframeEvaluationSummaryAucRoc.Builder, ObjectBuilder<DataframeEvaluationSummaryAucRoc>> fn) {
            return this.aucRoc(fn.apply(new DataframeEvaluationSummaryAucRoc.Builder()).build());
        }

        public final Builder precision(Map<String, Double> map) {
            this.precision = Builder._mapPutAll(this.precision, map);
            return this;
        }

        public final Builder precision(String key, Double value) {
            this.precision = Builder._mapPut(this.precision, key, value);
            return this;
        }

        public final Builder recall(Map<String, Double> map) {
            this.recall = Builder._mapPutAll(this.recall, map);
            return this;
        }

        public final Builder recall(String key, Double value) {
            this.recall = Builder._mapPut(this.recall, key, value);
            return this;
        }

        public final Builder confusionMatrix(Map<String, ConfusionMatrixThreshold> map) {
            this.confusionMatrix = Builder._mapPutAll(this.confusionMatrix, map);
            return this;
        }

        public final Builder confusionMatrix(String key, ConfusionMatrixThreshold value) {
            this.confusionMatrix = Builder._mapPut(this.confusionMatrix, key, value);
            return this;
        }

        public final Builder confusionMatrix(String key, Function<ConfusionMatrixThreshold.Builder, ObjectBuilder<ConfusionMatrixThreshold>> fn) {
            return this.confusionMatrix(key, fn.apply(new ConfusionMatrixThreshold.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeOutlierDetectionSummary build() {
            this._checkSingleUse();
            return new DataframeOutlierDetectionSummary(this);
        }
    }
}

