/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.analysis.CharFilter;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.Tokenizer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CategorizationAnalyzerDefinition
implements JsonpSerializable {
    private final List<CharFilter> charFilter;
    private final List<TokenFilter> filter;
    @Nullable
    private final Tokenizer tokenizer;
    public static final JsonpDeserializer<CategorizationAnalyzerDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CategorizationAnalyzerDefinition::setupCategorizationAnalyzerDefinitionDeserializer);

    private CategorizationAnalyzerDefinition(Builder builder) {
        this.charFilter = ApiTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.tokenizer = builder.tokenizer;
    }

    public static CategorizationAnalyzerDefinition of(Function<Builder, ObjectBuilder<CategorizationAnalyzerDefinition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<CharFilter> charFilter() {
        return this.charFilter;
    }

    public final List<TokenFilter> filter() {
        return this.filter;
    }

    @Nullable
    public final Tokenizer tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.charFilter)) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (CharFilter charFilter : this.charFilter) {
                charFilter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (TokenFilter tokenFilter : this.filter) {
                tokenFilter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tokenizer != null) {
            generator.writeKey("tokenizer");
            this.tokenizer.serialize(generator, mapper);
        }
    }

    protected static void setupCategorizationAnalyzerDefinitionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(CharFilter._DESERIALIZER), "char_filter");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(TokenFilter._DESERIALIZER), "filter");
        op.add(Builder::tokenizer, Tokenizer._DESERIALIZER, "tokenizer");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CategorizationAnalyzerDefinition> {
        @Nullable
        private List<CharFilter> charFilter;
        @Nullable
        private List<TokenFilter> filter;
        @Nullable
        private Tokenizer tokenizer;

        public final Builder charFilter(List<CharFilter> list) {
            this.charFilter = Builder._listAddAll(this.charFilter, list);
            return this;
        }

        public final Builder charFilter(CharFilter value, CharFilter ... values) {
            this.charFilter = Builder._listAdd(this.charFilter, value, values);
            return this;
        }

        public final Builder charFilter(Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.charFilter(fn.apply(new CharFilter.Builder()).build(), new CharFilter[0]);
        }

        public final Builder filter(List<TokenFilter> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        public final Builder filter(TokenFilter value, TokenFilter ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        public final Builder filter(Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.filter(fn.apply(new TokenFilter.Builder()).build(), new TokenFilter[0]);
        }

        public final Builder tokenizer(@Nullable Tokenizer value) {
            this.tokenizer = value;
            return this;
        }

        public final Builder tokenizer(Function<Tokenizer.Builder, ObjectBuilder<Tokenizer>> fn) {
            return this.tokenizer(fn.apply(new Tokenizer.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CategorizationAnalyzerDefinition build() {
            this._checkSingleUse();
            return new CategorizationAnalyzerDefinition(this);
        }
    }
}

