/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.StoredScript;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetScriptResponse
implements JsonpSerializable {
    private final String id;
    private final boolean found;
    @Nullable
    private final StoredScript script;
    public static final JsonpDeserializer<GetScriptResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetScriptResponse::setupGetScriptResponseDeserializer);

    private GetScriptResponse(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.found = ApiTypeHelper.requireNonNull(builder.found, this, "found");
        this.script = builder.script;
    }

    public static GetScriptResponse of(Function<Builder, ObjectBuilder<GetScriptResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final boolean found() {
        return this.found;
    }

    @Nullable
    public final StoredScript script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("found");
        generator.write(this.found);
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    protected static void setupGetScriptResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found");
        op.add(Builder::script, StoredScript._DESERIALIZER, "script");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetScriptResponse> {
        private String id;
        private Boolean found;
        @Nullable
        private StoredScript script;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder found(boolean value) {
            this.found = value;
            return this;
        }

        public final Builder script(@Nullable StoredScript value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<StoredScript.Builder, ObjectBuilder<StoredScript>> fn) {
            return this.script(fn.apply(new StoredScript.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetScriptResponse build() {
            this._checkSingleUse();
            return new GetScriptResponse(this);
        }
    }
}

