/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.FieldRule;
import co.elastic.clients.elasticsearch.security.RoleMappingRuleVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RoleMappingRule
implements TaggedUnion<Kind, Object>,
RoleMappingRuleVariant,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<RoleMappingRule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleMappingRule::setupRoleMappingRuleDeserializer, Builder::build);

    @Override
    public Kind _roleMappingRuleKind() {
        return Kind.Except;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public RoleMappingRule(RoleMappingRuleVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._roleMappingRuleKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private RoleMappingRule(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static RoleMappingRule of(Function<Builder, ObjectBuilder<RoleMappingRule>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isAny() {
        return this._kind == Kind.Any;
    }

    public List<RoleMappingRule> any() {
        return (List)TaggedUnionUtils.get(this, Kind.Any);
    }

    public boolean isAll() {
        return this._kind == Kind.All;
    }

    public List<RoleMappingRule> all() {
        return (List)TaggedUnionUtils.get(this, Kind.All);
    }

    public boolean isField() {
        return this._kind == Kind.Field;
    }

    public FieldRule field() {
        return (FieldRule)TaggedUnionUtils.get(this, Kind.Field);
    }

    public boolean isExcept() {
        return this._kind == Kind.Except;
    }

    public RoleMappingRule except() {
        return (RoleMappingRule)TaggedUnionUtils.get(this, Kind.Except);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Any: {
                    generator.writeStartArray();
                    for (RoleMappingRule item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case All: {
                    generator.writeStartArray();
                    for (RoleMappingRule item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupRoleMappingRuleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::any, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "any");
        op.add(Builder::all, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "all");
        op.add(Builder::field, FieldRule._DESERIALIZER, "field");
        op.add(Builder::except, _DESERIALIZER, "except");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RoleMappingRule> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<RoleMappingRule> any(List<RoleMappingRule> v) {
            this._kind = Kind.Any;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleMappingRule> all(List<RoleMappingRule> v) {
            this._kind = Kind.All;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleMappingRule> field(FieldRule v) {
            this._kind = Kind.Field;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleMappingRule> field(Function<FieldRule.Builder, ObjectBuilder<FieldRule>> fn) {
            return this.field(fn.apply(new FieldRule.Builder()).build());
        }

        public ObjectBuilder<RoleMappingRule> except(RoleMappingRule v) {
            this._kind = Kind.Except;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RoleMappingRule> except(Function<Builder, ObjectBuilder<RoleMappingRule>> fn) {
            return this.except(fn.apply(new Builder()).build());
        }

        @Override
        public RoleMappingRule build() {
            this._checkSingleUse();
            return new RoleMappingRule(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Any("any"),
        All("all"),
        Field("field"),
        Except("except");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

