/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Cgroup;
import co.elastic.clients.elasticsearch.nodes.Cpu;
import co.elastic.clients.elasticsearch.nodes.ExtendedMemoryStats;
import co.elastic.clients.elasticsearch.nodes.MemoryStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OperatingSystem
implements JsonpSerializable {
    @Nullable
    private final Cpu cpu;
    @Nullable
    private final ExtendedMemoryStats mem;
    @Nullable
    private final MemoryStats swap;
    @Nullable
    private final Cgroup cgroup;
    @Nullable
    private final Long timestamp;
    public static final JsonpDeserializer<OperatingSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OperatingSystem::setupOperatingSystemDeserializer);

    private OperatingSystem(Builder builder) {
        this.cpu = builder.cpu;
        this.mem = builder.mem;
        this.swap = builder.swap;
        this.cgroup = builder.cgroup;
        this.timestamp = builder.timestamp;
    }

    public static OperatingSystem of(Function<Builder, ObjectBuilder<OperatingSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Cpu cpu() {
        return this.cpu;
    }

    @Nullable
    public final ExtendedMemoryStats mem() {
        return this.mem;
    }

    @Nullable
    public final MemoryStats swap() {
        return this.swap;
    }

    @Nullable
    public final Cgroup cgroup() {
        return this.cgroup;
    }

    @Nullable
    public final Long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cpu != null) {
            generator.writeKey("cpu");
            this.cpu.serialize(generator, mapper);
        }
        if (this.mem != null) {
            generator.writeKey("mem");
            this.mem.serialize(generator, mapper);
        }
        if (this.swap != null) {
            generator.writeKey("swap");
            this.swap.serialize(generator, mapper);
        }
        if (this.cgroup != null) {
            generator.writeKey("cgroup");
            this.cgroup.serialize(generator, mapper);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp.longValue());
        }
    }

    protected static void setupOperatingSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cpu, Cpu._DESERIALIZER, "cpu");
        op.add(Builder::mem, ExtendedMemoryStats._DESERIALIZER, "mem");
        op.add(Builder::swap, MemoryStats._DESERIALIZER, "swap");
        op.add(Builder::cgroup, Cgroup._DESERIALIZER, "cgroup");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OperatingSystem> {
        @Nullable
        private Cpu cpu;
        @Nullable
        private ExtendedMemoryStats mem;
        @Nullable
        private MemoryStats swap;
        @Nullable
        private Cgroup cgroup;
        @Nullable
        private Long timestamp;

        public final Builder cpu(@Nullable Cpu value) {
            this.cpu = value;
            return this;
        }

        public final Builder cpu(Function<Cpu.Builder, ObjectBuilder<Cpu>> fn) {
            return this.cpu(fn.apply(new Cpu.Builder()).build());
        }

        public final Builder mem(@Nullable ExtendedMemoryStats value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<ExtendedMemoryStats.Builder, ObjectBuilder<ExtendedMemoryStats>> fn) {
            return this.mem(fn.apply(new ExtendedMemoryStats.Builder()).build());
        }

        public final Builder swap(@Nullable MemoryStats value) {
            this.swap = value;
            return this;
        }

        public final Builder swap(Function<MemoryStats.Builder, ObjectBuilder<MemoryStats>> fn) {
            return this.swap(fn.apply(new MemoryStats.Builder()).build());
        }

        public final Builder cgroup(@Nullable Cgroup value) {
            this.cgroup = value;
            return this;
        }

        public final Builder cgroup(Function<Cgroup.Builder, ObjectBuilder<Cgroup>> fn) {
            return this.cgroup(fn.apply(new Cgroup.Builder()).build());
        }

        public final Builder timestamp(@Nullable Long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OperatingSystem build() {
            this._checkSingleUse();
            return new OperatingSystem(this);
        }
    }
}

