/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeAnalyticsMemoryEstimation
implements JsonpSerializable {
    private final String expectedMemoryWithDisk;
    private final String expectedMemoryWithoutDisk;
    public static final JsonpDeserializer<DataframeAnalyticsMemoryEstimation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsMemoryEstimation::setupDataframeAnalyticsMemoryEstimationDeserializer);

    private DataframeAnalyticsMemoryEstimation(Builder builder) {
        this.expectedMemoryWithDisk = ApiTypeHelper.requireNonNull(builder.expectedMemoryWithDisk, this, "expectedMemoryWithDisk");
        this.expectedMemoryWithoutDisk = ApiTypeHelper.requireNonNull(builder.expectedMemoryWithoutDisk, this, "expectedMemoryWithoutDisk");
    }

    public static DataframeAnalyticsMemoryEstimation of(Function<Builder, ObjectBuilder<DataframeAnalyticsMemoryEstimation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String expectedMemoryWithDisk() {
        return this.expectedMemoryWithDisk;
    }

    public final String expectedMemoryWithoutDisk() {
        return this.expectedMemoryWithoutDisk;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("expected_memory_with_disk");
        generator.write(this.expectedMemoryWithDisk);
        generator.writeKey("expected_memory_without_disk");
        generator.write(this.expectedMemoryWithoutDisk);
    }

    protected static void setupDataframeAnalyticsMemoryEstimationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::expectedMemoryWithDisk, JsonpDeserializer.stringDeserializer(), "expected_memory_with_disk");
        op.add(Builder::expectedMemoryWithoutDisk, JsonpDeserializer.stringDeserializer(), "expected_memory_without_disk");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeAnalyticsMemoryEstimation> {
        private String expectedMemoryWithDisk;
        private String expectedMemoryWithoutDisk;

        public final Builder expectedMemoryWithDisk(String value) {
            this.expectedMemoryWithDisk = value;
            return this;
        }

        public final Builder expectedMemoryWithoutDisk(String value) {
            this.expectedMemoryWithoutDisk = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalyticsMemoryEstimation build() {
            this._checkSingleUse();
            return new DataframeAnalyticsMemoryEstimation(this);
        }
    }
}

