/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.elasticsearch.license.LicenseType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PostStartTrialResponse
extends AcknowledgedResponseBase {
    @Nullable
    private final String errorMessage;
    private final boolean trialWasStarted;
    @Nullable
    private final LicenseType type;
    public static final JsonpDeserializer<PostStartTrialResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostStartTrialResponse::setupPostStartTrialResponseDeserializer);

    private PostStartTrialResponse(Builder builder) {
        super(builder);
        this.errorMessage = builder.errorMessage;
        this.trialWasStarted = ApiTypeHelper.requireNonNull(builder.trialWasStarted, this, "trialWasStarted");
        this.type = builder.type;
    }

    public static PostStartTrialResponse of(Function<Builder, ObjectBuilder<PostStartTrialResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String errorMessage() {
        return this.errorMessage;
    }

    public final boolean trialWasStarted() {
        return this.trialWasStarted;
    }

    @Nullable
    public final LicenseType type() {
        return this.type;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.errorMessage != null) {
            generator.writeKey("error_message");
            generator.write(this.errorMessage);
        }
        generator.writeKey("trial_was_started");
        generator.write(this.trialWasStarted);
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
    }

    protected static void setupPostStartTrialResponseDeserializer(ObjectDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::errorMessage, JsonpDeserializer.stringDeserializer(), "error_message");
        op.add(Builder::trialWasStarted, JsonpDeserializer.booleanDeserializer(), "trial_was_started");
        op.add(Builder::type, LicenseType._DESERIALIZER, "type");
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PostStartTrialResponse> {
        @Nullable
        private String errorMessage;
        private Boolean trialWasStarted;
        @Nullable
        private LicenseType type;

        public final Builder errorMessage(@Nullable String value) {
            this.errorMessage = value;
            return this;
        }

        public final Builder trialWasStarted(boolean value) {
            this.trialWasStarted = value;
            return this;
        }

        public final Builder type(@Nullable LicenseType value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostStartTrialResponse build() {
            this._checkSingleUse();
            return new PostStartTrialResponse(this);
        }
    }
}

