/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;

public abstract class SuggestBase
implements JsonpSerializable {
    private final int length;
    private final int offset;
    private final String text;

    protected SuggestBase(AbstractBuilder<?> builder) {
        this.length = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).length, this, "length");
        this.offset = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).offset, this, "offset");
        this.text = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).text, this, "text");
    }

    public final int length() {
        return this.length;
    }

    public final int offset() {
        return this.offset;
    }

    public final String text() {
        return this.text;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("length");
        generator.write(this.length);
        generator.writeKey("offset");
        generator.write(this.offset);
        generator.writeKey("text");
        generator.write(this.text);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSuggestBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::length, JsonpDeserializer.integerDeserializer(), "length");
        op.add(AbstractBuilder::offset, JsonpDeserializer.integerDeserializer(), "offset");
        op.add(AbstractBuilder::text, JsonpDeserializer.stringDeserializer(), "text");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private Integer length;
        private Integer offset;
        private String text;

        protected AbstractBuilder() {
        }

        public final BuilderT length(int value) {
            this.length = value;
            return (BuilderT)this.self();
        }

        public final BuilderT offset(int value) {
            this.offset = value;
            return (BuilderT)this.self();
        }

        public final BuilderT text(String value) {
            this.text = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

