/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NodePackagingType
implements JsonpSerializable {
    private final int count;
    private final String flavor;
    private final String type;
    public static final JsonpDeserializer<NodePackagingType> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodePackagingType::setupNodePackagingTypeDeserializer);

    private NodePackagingType(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.flavor = ApiTypeHelper.requireNonNull(builder.flavor, this, "flavor");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static NodePackagingType of(Function<Builder, ObjectBuilder<NodePackagingType>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    public final String flavor() {
        return this.flavor;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("flavor");
        generator.write(this.flavor);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupNodePackagingTypeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::flavor, JsonpDeserializer.stringDeserializer(), "flavor");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodePackagingType> {
        private Integer count;
        private String flavor;
        private String type;

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder flavor(String value) {
            this.flavor = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodePackagingType build() {
            this._checkSingleUse();
            return new NodePackagingType(this);
        }
    }
}

