/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.IndexingPressureMemorySummary;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class IndexingPressureMemory
implements JsonpSerializable {
    private final long limitInBytes;
    private final IndexingPressureMemorySummary current;
    private final IndexingPressureMemorySummary total;
    public static final JsonpDeserializer<IndexingPressureMemory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexingPressureMemory::setupIndexingPressureMemoryDeserializer);

    private IndexingPressureMemory(Builder builder) {
        this.limitInBytes = ApiTypeHelper.requireNonNull(builder.limitInBytes, this, "limitInBytes");
        this.current = ApiTypeHelper.requireNonNull(builder.current, this, "current");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static IndexingPressureMemory of(Function<Builder, ObjectBuilder<IndexingPressureMemory>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long limitInBytes() {
        return this.limitInBytes;
    }

    public final IndexingPressureMemorySummary current() {
        return this.current;
    }

    public final IndexingPressureMemorySummary total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("limit_in_bytes");
        generator.write(this.limitInBytes);
        generator.writeKey("current");
        this.current.serialize(generator, mapper);
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
    }

    protected static void setupIndexingPressureMemoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::limitInBytes, JsonpDeserializer.longDeserializer(), "limit_in_bytes");
        op.add(Builder::current, IndexingPressureMemorySummary._DESERIALIZER, "current");
        op.add(Builder::total, IndexingPressureMemorySummary._DESERIALIZER, "total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexingPressureMemory> {
        private Long limitInBytes;
        private IndexingPressureMemorySummary current;
        private IndexingPressureMemorySummary total;

        public final Builder limitInBytes(long value) {
            this.limitInBytes = value;
            return this;
        }

        public final Builder current(IndexingPressureMemorySummary value) {
            this.current = value;
            return this;
        }

        public final Builder current(Function<IndexingPressureMemorySummary.Builder, ObjectBuilder<IndexingPressureMemorySummary>> fn) {
            return this.current(fn.apply(new IndexingPressureMemorySummary.Builder()).build());
        }

        public final Builder total(IndexingPressureMemorySummary value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<IndexingPressureMemorySummary.Builder, ObjectBuilder<IndexingPressureMemorySummary>> fn) {
            return this.total(fn.apply(new IndexingPressureMemorySummary.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexingPressureMemory build() {
            this._checkSingleUse();
            return new IndexingPressureMemory(this);
        }
    }
}

