/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class KnnQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final int numCandidates;
    private final List<Double> queryVector;
    public static final JsonpDeserializer<KnnQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnQuery::setupKnnQueryDeserializer);

    private KnnQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.numCandidates = ApiTypeHelper.requireNonNull(builder.numCandidates, this, "numCandidates");
        this.queryVector = ApiTypeHelper.unmodifiableRequired(builder.queryVector, (Object)this, "queryVector");
    }

    public static KnnQuery of(Function<Builder, ObjectBuilder<KnnQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Knn;
    }

    public final String field() {
        return this.field;
    }

    public final int numCandidates() {
        return this.numCandidates;
    }

    public final List<Double> queryVector() {
        return this.queryVector;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("num_candidates");
        generator.write(this.numCandidates);
        if (ApiTypeHelper.isDefined(this.queryVector)) {
            generator.writeKey("query_vector");
            generator.writeStartArray();
            for (Double item0 : this.queryVector) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupKnnQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::numCandidates, JsonpDeserializer.integerDeserializer(), "num_candidates");
        op.add(Builder::queryVector, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "query_vector");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KnnQuery> {
        private String field;
        private Integer numCandidates;
        private List<Double> queryVector;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder numCandidates(int value) {
            this.numCandidates = value;
            return this;
        }

        public final Builder queryVector(List<Double> list) {
            this.queryVector = Builder._listAddAll(this.queryVector, list);
            return this;
        }

        public final Builder queryVector(Double value, Double ... values) {
            this.queryVector = Builder._listAdd(this.queryVector, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KnnQuery build() {
            this._checkSingleUse();
            return new KnnQuery(this);
        }
    }
}

