/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.NodeRole;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class BaseNode
implements JsonpSerializable {
    private final Map<String, String> attributes;
    private final String host;
    private final String ip;
    private final String name;
    private final List<NodeRole> roles;
    private final String transportAddress;

    protected BaseNode(AbstractBuilder<?> builder) {
        this.attributes = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).attributes, (Object)this, "attributes");
        this.host = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).host, this, "host");
        this.ip = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).ip, this, "ip");
        this.name = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).name, this, "name");
        this.roles = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).roles);
        this.transportAddress = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).transportAddress, this, "transportAddress");
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String host() {
        return this.host;
    }

    public final String ip() {
        return this.ip;
    }

    public final String name() {
        return this.name;
    }

    public final List<NodeRole> roles() {
        return this.roles;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("host");
        generator.write(this.host);
        generator.writeKey("ip");
        generator.write(this.ip);
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBaseNodeDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(AbstractBuilder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(AbstractBuilder::ip, JsonpDeserializer.stringDeserializer(), "ip");
        op.add(AbstractBuilder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(AbstractBuilder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles");
        op.add(AbstractBuilder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private Map<String, String> attributes;
        private String host;
        private String ip;
        private String name;
        @Nullable
        private List<NodeRole> roles;
        private String transportAddress;

        protected AbstractBuilder() {
        }

        public final BuilderT attributes(Map<String, String> map) {
            this.attributes = AbstractBuilder._mapPutAll(this.attributes, map);
            return (BuilderT)this.self();
        }

        public final BuilderT attributes(String key, String value) {
            this.attributes = AbstractBuilder._mapPut(this.attributes, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT host(String value) {
            this.host = value;
            return (BuilderT)this.self();
        }

        public final BuilderT ip(String value) {
            this.ip = value;
            return (BuilderT)this.self();
        }

        public final BuilderT name(String value) {
            this.name = value;
            return (BuilderT)this.self();
        }

        public final BuilderT roles(List<NodeRole> list) {
            this.roles = AbstractBuilder._listAddAll(this.roles, list);
            return (BuilderT)this.self();
        }

        public final BuilderT roles(NodeRole value, NodeRole ... values) {
            this.roles = AbstractBuilder._listAdd(this.roles, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT transportAddress(String value) {
            this.transportAddress = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

