/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.get_service_credentials.NodesCredentials;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class GetServiceCredentialsResponse
implements JsonpSerializable {
    private final String serviceAccount;
    private final int count;
    private final Map<String, Map<String, JsonData>> tokens;
    private final NodesCredentials nodesCredentials;
    public static final JsonpDeserializer<GetServiceCredentialsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetServiceCredentialsResponse::setupGetServiceCredentialsResponseDeserializer);

    private GetServiceCredentialsResponse(Builder builder) {
        this.serviceAccount = ApiTypeHelper.requireNonNull(builder.serviceAccount, this, "serviceAccount");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.tokens = ApiTypeHelper.unmodifiableRequired(builder.tokens, (Object)this, "tokens");
        this.nodesCredentials = ApiTypeHelper.requireNonNull(builder.nodesCredentials, this, "nodesCredentials");
    }

    public static GetServiceCredentialsResponse of(Function<Builder, ObjectBuilder<GetServiceCredentialsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String serviceAccount() {
        return this.serviceAccount;
    }

    public final int count() {
        return this.count;
    }

    public final Map<String, Map<String, JsonData>> tokens() {
        return this.tokens;
    }

    public final NodesCredentials nodesCredentials() {
        return this.nodesCredentials;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("service_account");
        generator.write(this.serviceAccount);
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.tokens)) {
            generator.writeKey("tokens");
            generator.writeStartObject();
            for (Map.Entry<String, Map<String, JsonData>> item0 : this.tokens.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartObject();
                if (item0.getValue() != null) {
                    for (Map.Entry<String, JsonData> item1 : item0.getValue().entrySet()) {
                        generator.writeKey(item1.getKey());
                        item1.getValue().serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("nodes_credentials");
        this.nodesCredentials.serialize(generator, mapper);
    }

    protected static void setupGetServiceCredentialsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::serviceAccount, JsonpDeserializer.stringDeserializer(), "service_account");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::tokens, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "tokens");
        op.add(Builder::nodesCredentials, NodesCredentials._DESERIALIZER, "nodes_credentials");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetServiceCredentialsResponse> {
        private String serviceAccount;
        private Integer count;
        private Map<String, Map<String, JsonData>> tokens;
        private NodesCredentials nodesCredentials;

        public final Builder serviceAccount(String value) {
            this.serviceAccount = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder tokens(Map<String, Map<String, JsonData>> map) {
            this.tokens = Builder._mapPutAll(this.tokens, map);
            return this;
        }

        public final Builder tokens(String key, Map<String, JsonData> value) {
            this.tokens = Builder._mapPut(this.tokens, key, value);
            return this;
        }

        public final Builder nodesCredentials(NodesCredentials value) {
            this.nodesCredentials = value;
            return this;
        }

        public final Builder nodesCredentials(Function<NodesCredentials.Builder, ObjectBuilder<NodesCredentials>> fn) {
            return this.nodesCredentials(fn.apply(new NodesCredentials.Builder()).build());
        }

        @Override
        public GetServiceCredentialsResponse build() {
            this._checkSingleUse();
            return new GetServiceCredentialsResponse(this);
        }
    }
}

