/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.rollup.RollupResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.function.Function;

@JsonpDeserializable
public class RollupRequest
extends RequestBase
implements JsonpSerializable {
    private final String index;
    private final String rollupIndex;
    private final JsonData config;
    public static final JsonpDeserializer<RollupRequest> _DESERIALIZER = RollupRequest.createRollupRequestDeserializer();
    public static final Endpoint<RollupRequest, RollupResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RollupRequest, RollupResponse>("es/rollup.rollup", request -> "POST", request -> {
        boolean _rollupIndex = true;
        int _index = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_rollup");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.rollupIndex, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, RollupResponse._DESERIALIZER);

    private RollupRequest(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.rollupIndex = ApiTypeHelper.requireNonNull(builder.rollupIndex, this, "rollupIndex");
        this.config = ApiTypeHelper.requireNonNull(builder.config, this, "config");
    }

    public static RollupRequest of(Function<Builder, ObjectBuilder<RollupRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final String rollupIndex() {
        return this.rollupIndex;
    }

    public final JsonData config() {
        return this.config;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.config.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<RollupRequest> createRollupRequestDeserializer() {
        JsonpDeserializer<JsonData> valueDeserializer = JsonData._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().config((JsonData)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RollupRequest> {
        private String index;
        private String rollupIndex;
        private JsonData config;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder rollupIndex(String value) {
            this.rollupIndex = value;
            return this;
        }

        public final Builder config(JsonData value) {
            this.config = value;
            return this;
        }

        @Override
        public RollupRequest build() {
            this._checkSingleUse();
            return new RollupRequest(this);
        }
    }
}

