/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.IoStatDevice;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IoStats
implements JsonpSerializable {
    private final List<IoStatDevice> devices;
    @Nullable
    private final IoStatDevice total;
    public static final JsonpDeserializer<IoStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IoStats::setupIoStatsDeserializer);

    private IoStats(Builder builder) {
        this.devices = ApiTypeHelper.unmodifiable(builder.devices);
        this.total = builder.total;
    }

    public static IoStats of(Function<Builder, ObjectBuilder<IoStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<IoStatDevice> devices() {
        return this.devices;
    }

    @Nullable
    public final IoStatDevice total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.devices)) {
            generator.writeKey("devices");
            generator.writeStartArray();
            for (IoStatDevice item0 : this.devices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
    }

    protected static void setupIoStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::devices, JsonpDeserializer.arrayDeserializer(IoStatDevice._DESERIALIZER), "devices");
        op.add(Builder::total, IoStatDevice._DESERIALIZER, "total");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IoStats> {
        @Nullable
        private List<IoStatDevice> devices;
        @Nullable
        private IoStatDevice total;

        public final Builder devices(List<IoStatDevice> list) {
            this.devices = Builder._listAddAll(this.devices, list);
            return this;
        }

        public final Builder devices(IoStatDevice value, IoStatDevice ... values) {
            this.devices = Builder._listAdd(this.devices, value, values);
            return this;
        }

        public final Builder devices(Function<IoStatDevice.Builder, ObjectBuilder<IoStatDevice>> fn) {
            return this.devices(fn.apply(new IoStatDevice.Builder()).build(), new IoStatDevice[0]);
        }

        public final Builder total(@Nullable IoStatDevice value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<IoStatDevice.Builder, ObjectBuilder<IoStatDevice>> fn) {
            return this.total(fn.apply(new IoStatDevice.Builder()).build());
        }

        @Override
        public IoStats build() {
            this._checkSingleUse();
            return new IoStats(this);
        }
    }
}

