/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.GarbageCollectorTotal;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GarbageCollector
implements JsonpSerializable {
    private final Map<String, GarbageCollectorTotal> collectors;
    public static final JsonpDeserializer<GarbageCollector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GarbageCollector::setupGarbageCollectorDeserializer);

    private GarbageCollector(Builder builder) {
        this.collectors = ApiTypeHelper.unmodifiable(builder.collectors);
    }

    public static GarbageCollector of(Function<Builder, ObjectBuilder<GarbageCollector>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, GarbageCollectorTotal> collectors() {
        return this.collectors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.collectors)) {
            generator.writeKey("collectors");
            generator.writeStartObject();
            for (Map.Entry<String, GarbageCollectorTotal> item0 : this.collectors.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGarbageCollectorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collectors, JsonpDeserializer.stringMapDeserializer(GarbageCollectorTotal._DESERIALIZER), "collectors");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GarbageCollector> {
        @Nullable
        private Map<String, GarbageCollectorTotal> collectors;

        public final Builder collectors(Map<String, GarbageCollectorTotal> map) {
            this.collectors = Builder._mapPutAll(this.collectors, map);
            return this;
        }

        public final Builder collectors(String key, GarbageCollectorTotal value) {
            this.collectors = Builder._mapPut(this.collectors, key, value);
            return this;
        }

        public final Builder collectors(String key, Function<GarbageCollectorTotal.Builder, ObjectBuilder<GarbageCollectorTotal>> fn) {
            return this.collectors(key, fn.apply(new GarbageCollectorTotal.Builder()).build());
        }

        @Override
        public GarbageCollector build() {
            this._checkSingleUse();
            return new GarbageCollector(this);
        }
    }
}

