/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DetectionRule;
import co.elastic.clients.elasticsearch.ml.ExcludeFrequent;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DetectorRead
implements JsonpSerializable {
    @Nullable
    private final String byFieldName;
    private final List<DetectionRule> customRules;
    @Nullable
    private final String detectorDescription;
    @Nullable
    private final Integer detectorIndex;
    @Nullable
    private final ExcludeFrequent excludeFrequent;
    @Nullable
    private final String fieldName;
    private final String function;
    @Nullable
    private final String overFieldName;
    @Nullable
    private final String partitionFieldName;
    @Nullable
    private final Boolean useNull;
    public static final JsonpDeserializer<DetectorRead> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DetectorRead::setupDetectorReadDeserializer);

    private DetectorRead(Builder builder) {
        this.byFieldName = builder.byFieldName;
        this.customRules = ApiTypeHelper.unmodifiable(builder.customRules);
        this.detectorDescription = builder.detectorDescription;
        this.detectorIndex = builder.detectorIndex;
        this.excludeFrequent = builder.excludeFrequent;
        this.fieldName = builder.fieldName;
        this.function = ApiTypeHelper.requireNonNull(builder.function, this, "function");
        this.overFieldName = builder.overFieldName;
        this.partitionFieldName = builder.partitionFieldName;
        this.useNull = builder.useNull;
    }

    public static DetectorRead of(Function<Builder, ObjectBuilder<DetectorRead>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String byFieldName() {
        return this.byFieldName;
    }

    public final List<DetectionRule> customRules() {
        return this.customRules;
    }

    @Nullable
    public final String detectorDescription() {
        return this.detectorDescription;
    }

    @Nullable
    public final Integer detectorIndex() {
        return this.detectorIndex;
    }

    @Nullable
    public final ExcludeFrequent excludeFrequent() {
        return this.excludeFrequent;
    }

    @Nullable
    public final String fieldName() {
        return this.fieldName;
    }

    public final String function() {
        return this.function;
    }

    @Nullable
    public final String overFieldName() {
        return this.overFieldName;
    }

    @Nullable
    public final String partitionFieldName() {
        return this.partitionFieldName;
    }

    @Nullable
    public final Boolean useNull() {
        return this.useNull;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.byFieldName != null) {
            generator.writeKey("by_field_name");
            generator.write(this.byFieldName);
        }
        if (ApiTypeHelper.isDefined(this.customRules)) {
            generator.writeKey("custom_rules");
            generator.writeStartArray();
            for (DetectionRule item0 : this.customRules) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.detectorDescription != null) {
            generator.writeKey("detector_description");
            generator.write(this.detectorDescription);
        }
        if (this.detectorIndex != null) {
            generator.writeKey("detector_index");
            generator.write(this.detectorIndex.intValue());
        }
        if (this.excludeFrequent != null) {
            generator.writeKey("exclude_frequent");
            this.excludeFrequent.serialize(generator, mapper);
        }
        if (this.fieldName != null) {
            generator.writeKey("field_name");
            generator.write(this.fieldName);
        }
        generator.writeKey("function");
        generator.write(this.function);
        if (this.overFieldName != null) {
            generator.writeKey("over_field_name");
            generator.write(this.overFieldName);
        }
        if (this.partitionFieldName != null) {
            generator.writeKey("partition_field_name");
            generator.write(this.partitionFieldName);
        }
        if (this.useNull != null) {
            generator.writeKey("use_null");
            generator.write(this.useNull.booleanValue());
        }
    }

    protected static void setupDetectorReadDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::byFieldName, JsonpDeserializer.stringDeserializer(), "by_field_name");
        op.add(Builder::customRules, JsonpDeserializer.arrayDeserializer(DetectionRule._DESERIALIZER), "custom_rules");
        op.add(Builder::detectorDescription, JsonpDeserializer.stringDeserializer(), "detector_description");
        op.add(Builder::detectorIndex, JsonpDeserializer.integerDeserializer(), "detector_index");
        op.add(Builder::excludeFrequent, ExcludeFrequent._DESERIALIZER, "exclude_frequent");
        op.add(Builder::fieldName, JsonpDeserializer.stringDeserializer(), "field_name");
        op.add(Builder::function, JsonpDeserializer.stringDeserializer(), "function");
        op.add(Builder::overFieldName, JsonpDeserializer.stringDeserializer(), "over_field_name");
        op.add(Builder::partitionFieldName, JsonpDeserializer.stringDeserializer(), "partition_field_name");
        op.add(Builder::useNull, JsonpDeserializer.booleanDeserializer(), "use_null");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DetectorRead> {
        @Nullable
        private String byFieldName;
        @Nullable
        private List<DetectionRule> customRules;
        @Nullable
        private String detectorDescription;
        @Nullable
        private Integer detectorIndex;
        @Nullable
        private ExcludeFrequent excludeFrequent;
        @Nullable
        private String fieldName;
        private String function;
        @Nullable
        private String overFieldName;
        @Nullable
        private String partitionFieldName;
        @Nullable
        private Boolean useNull;

        public final Builder byFieldName(@Nullable String value) {
            this.byFieldName = value;
            return this;
        }

        public final Builder customRules(List<DetectionRule> list) {
            this.customRules = Builder._listAddAll(this.customRules, list);
            return this;
        }

        public final Builder customRules(DetectionRule value, DetectionRule ... values) {
            this.customRules = Builder._listAdd(this.customRules, value, values);
            return this;
        }

        public final Builder customRules(Function<DetectionRule.Builder, ObjectBuilder<DetectionRule>> fn) {
            return this.customRules(fn.apply(new DetectionRule.Builder()).build(), new DetectionRule[0]);
        }

        public final Builder detectorDescription(@Nullable String value) {
            this.detectorDescription = value;
            return this;
        }

        public final Builder detectorIndex(@Nullable Integer value) {
            this.detectorIndex = value;
            return this;
        }

        public final Builder excludeFrequent(@Nullable ExcludeFrequent value) {
            this.excludeFrequent = value;
            return this;
        }

        public final Builder fieldName(@Nullable String value) {
            this.fieldName = value;
            return this;
        }

        public final Builder function(String value) {
            this.function = value;
            return this;
        }

        public final Builder overFieldName(@Nullable String value) {
            this.overFieldName = value;
            return this;
        }

        public final Builder partitionFieldName(@Nullable String value) {
            this.partitionFieldName = value;
            return this;
        }

        public final Builder useNull(@Nullable Boolean value) {
            this.useNull = value;
            return this;
        }

        @Override
        public DetectorRead build() {
            this._checkSingleUse();
            return new DetectorRead(this);
        }
    }
}

