/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.SnapshotsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SnapshotsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> repository;
    public static final Endpoint<SnapshotsRequest, SnapshotsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SnapshotsRequest, SnapshotsResponse>("es/cat.snapshots", request -> "GET", request -> {
        boolean _repository = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.repository())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/snapshots");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, SnapshotsResponse._DESERIALIZER);

    private SnapshotsRequest(Builder builder) {
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.repository = ApiTypeHelper.unmodifiable(builder.repository);
    }

    public static SnapshotsRequest of(Function<Builder, ObjectBuilder<SnapshotsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> repository() {
        return this.repository;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SnapshotsRequest> {
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> repository;

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder repository(List<String> list) {
            this.repository = Builder._listAddAll(this.repository, list);
            return this;
        }

        public final Builder repository(String value, String ... values) {
            this.repository = Builder._listAdd(this.repository, value, values);
            return this;
        }

        @Override
        public SnapshotsRequest build() {
            this._checkSingleUse();
            return new SnapshotsRequest(this);
        }
    }
}

