/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.UnassignedInformation;
import co.elastic.clients.elasticsearch.indices.stats.ShardRoutingState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeShard
implements JsonpSerializable {
    private final ShardRoutingState state;
    private final boolean primary;
    @Nullable
    private final String node;
    private final int shard;
    private final String index;
    private final Map<String, String> allocationId;
    private final Map<String, String> recoverySource;
    @Nullable
    private final UnassignedInformation unassignedInfo;
    @Nullable
    private final String relocatingNode;
    public static final JsonpDeserializer<NodeShard> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeShard::setupNodeShardDeserializer);

    private NodeShard(Builder builder) {
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.primary = ApiTypeHelper.requireNonNull(builder.primary, this, "primary");
        this.node = builder.node;
        this.shard = ApiTypeHelper.requireNonNull(builder.shard, this, "shard");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.allocationId = ApiTypeHelper.unmodifiable(builder.allocationId);
        this.recoverySource = ApiTypeHelper.unmodifiable(builder.recoverySource);
        this.unassignedInfo = builder.unassignedInfo;
        this.relocatingNode = builder.relocatingNode;
    }

    public static NodeShard of(Function<Builder, ObjectBuilder<NodeShard>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardRoutingState state() {
        return this.state;
    }

    public final boolean primary() {
        return this.primary;
    }

    @Nullable
    public final String node() {
        return this.node;
    }

    public final int shard() {
        return this.shard;
    }

    public final String index() {
        return this.index;
    }

    public final Map<String, String> allocationId() {
        return this.allocationId;
    }

    public final Map<String, String> recoverySource() {
        return this.recoverySource;
    }

    @Nullable
    public final UnassignedInformation unassignedInfo() {
        return this.unassignedInfo;
    }

    @Nullable
    public final String relocatingNode() {
        return this.relocatingNode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("primary");
        generator.write(this.primary);
        if (this.node != null) {
            generator.writeKey("node");
            generator.write(this.node);
        }
        generator.writeKey("shard");
        generator.write(this.shard);
        generator.writeKey("index");
        generator.write(this.index);
        if (ApiTypeHelper.isDefined(this.allocationId)) {
            generator.writeKey("allocation_id");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.allocationId.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.recoverySource)) {
            generator.writeKey("recovery_source");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.recoverySource.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.unassignedInfo != null) {
            generator.writeKey("unassigned_info");
            this.unassignedInfo.serialize(generator, mapper);
        }
        if (this.relocatingNode != null) {
            generator.writeKey("relocating_node");
            generator.write(this.relocatingNode);
        }
    }

    protected static void setupNodeShardDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::state, ShardRoutingState._DESERIALIZER, "state");
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::allocationId, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "allocation_id");
        op.add(Builder::recoverySource, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "recovery_source");
        op.add(Builder::unassignedInfo, UnassignedInformation._DESERIALIZER, "unassigned_info");
        op.add(Builder::relocatingNode, JsonpDeserializer.stringDeserializer(), "relocating_node");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeShard> {
        private ShardRoutingState state;
        private Boolean primary;
        @Nullable
        private String node;
        private Integer shard;
        private String index;
        @Nullable
        private Map<String, String> allocationId;
        @Nullable
        private Map<String, String> recoverySource;
        @Nullable
        private UnassignedInformation unassignedInfo;
        @Nullable
        private String relocatingNode;

        public final Builder state(ShardRoutingState value) {
            this.state = value;
            return this;
        }

        public final Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public final Builder node(@Nullable String value) {
            this.node = value;
            return this;
        }

        public final Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder allocationId(Map<String, String> map) {
            this.allocationId = Builder._mapPutAll(this.allocationId, map);
            return this;
        }

        public final Builder allocationId(String key, String value) {
            this.allocationId = Builder._mapPut(this.allocationId, key, value);
            return this;
        }

        public final Builder recoverySource(Map<String, String> map) {
            this.recoverySource = Builder._mapPutAll(this.recoverySource, map);
            return this;
        }

        public final Builder recoverySource(String key, String value) {
            this.recoverySource = Builder._mapPut(this.recoverySource, key, value);
            return this;
        }

        public final Builder unassignedInfo(@Nullable UnassignedInformation value) {
            this.unassignedInfo = value;
            return this;
        }

        public final Builder unassignedInfo(Function<UnassignedInformation.Builder, ObjectBuilder<UnassignedInformation>> fn) {
            return this.unassignedInfo(fn.apply(new UnassignedInformation.Builder()).build());
        }

        public final Builder relocatingNode(@Nullable String value) {
            this.relocatingNode = value;
            return this;
        }

        @Override
        public NodeShard build() {
            this._checkSingleUse();
            return new NodeShard(this);
        }
    }
}

