/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CharGroupTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.EdgeNGramTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.IcuTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.KeywordTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.LetterTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.LowercaseTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.NGramTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.NoriTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.PathHierarchyTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.PatternTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.StandardTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinitionVariant;
import co.elastic.clients.elasticsearch._types.analysis.UaxEmailUrlTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.WhitespaceTokenizer;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TokenizerDefinition
implements TaggedUnion<Kind, TokenizerDefinitionVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final TokenizerDefinitionVariant _value;
    public static final JsonpDeserializer<TokenizerDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TokenizerDefinition::setupTokenizerDefinitionDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final TokenizerDefinitionVariant _get() {
        return this._value;
    }

    public TokenizerDefinition(TokenizerDefinitionVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._tokenizerDefinitionKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private TokenizerDefinition(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TokenizerDefinition of(Function<Builder, ObjectBuilder<TokenizerDefinition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCharGroup() {
        return this._kind == Kind.CharGroup;
    }

    public CharGroupTokenizer charGroup() {
        return (CharGroupTokenizer)TaggedUnionUtils.get(this, Kind.CharGroup);
    }

    public boolean isEdgeNgram() {
        return this._kind == Kind.EdgeNgram;
    }

    public EdgeNGramTokenizer edgeNgram() {
        return (EdgeNGramTokenizer)TaggedUnionUtils.get(this, Kind.EdgeNgram);
    }

    public boolean isIcuTokenizer() {
        return this._kind == Kind.IcuTokenizer;
    }

    public IcuTokenizer icuTokenizer() {
        return (IcuTokenizer)TaggedUnionUtils.get(this, Kind.IcuTokenizer);
    }

    public boolean isKeyword() {
        return this._kind == Kind.Keyword;
    }

    public KeywordTokenizer keyword() {
        return (KeywordTokenizer)TaggedUnionUtils.get(this, Kind.Keyword);
    }

    public boolean isKuromojiTokenizer() {
        return this._kind == Kind.KuromojiTokenizer;
    }

    public KuromojiTokenizer kuromojiTokenizer() {
        return (KuromojiTokenizer)TaggedUnionUtils.get(this, Kind.KuromojiTokenizer);
    }

    public boolean isLetter() {
        return this._kind == Kind.Letter;
    }

    public LetterTokenizer letter() {
        return (LetterTokenizer)TaggedUnionUtils.get(this, Kind.Letter);
    }

    public boolean isLowercase() {
        return this._kind == Kind.Lowercase;
    }

    public LowercaseTokenizer lowercase() {
        return (LowercaseTokenizer)TaggedUnionUtils.get(this, Kind.Lowercase);
    }

    public boolean isNgram() {
        return this._kind == Kind.Ngram;
    }

    public NGramTokenizer ngram() {
        return (NGramTokenizer)TaggedUnionUtils.get(this, Kind.Ngram);
    }

    public boolean isNoriTokenizer() {
        return this._kind == Kind.NoriTokenizer;
    }

    public NoriTokenizer noriTokenizer() {
        return (NoriTokenizer)TaggedUnionUtils.get(this, Kind.NoriTokenizer);
    }

    public boolean isPathHierarchy() {
        return this._kind == Kind.PathHierarchy;
    }

    public PathHierarchyTokenizer pathHierarchy() {
        return (PathHierarchyTokenizer)TaggedUnionUtils.get(this, Kind.PathHierarchy);
    }

    public boolean isPattern() {
        return this._kind == Kind.Pattern;
    }

    public PatternTokenizer pattern() {
        return (PatternTokenizer)TaggedUnionUtils.get(this, Kind.Pattern);
    }

    public boolean isStandard() {
        return this._kind == Kind.Standard;
    }

    public StandardTokenizer standard() {
        return (StandardTokenizer)TaggedUnionUtils.get(this, Kind.Standard);
    }

    public boolean isUaxUrlEmail() {
        return this._kind == Kind.UaxUrlEmail;
    }

    public UaxEmailUrlTokenizer uaxUrlEmail() {
        return (UaxEmailUrlTokenizer)TaggedUnionUtils.get(this, Kind.UaxUrlEmail);
    }

    public boolean isWhitespace() {
        return this._kind == Kind.Whitespace;
    }

    public WhitespaceTokenizer whitespace() {
        return (WhitespaceTokenizer)TaggedUnionUtils.get(this, Kind.Whitespace);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    protected static void setupTokenizerDefinitionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::charGroup, CharGroupTokenizer._DESERIALIZER, "char_group");
        op.add(Builder::edgeNgram, EdgeNGramTokenizer._DESERIALIZER, "edge_ngram");
        op.add(Builder::icuTokenizer, IcuTokenizer._DESERIALIZER, "icu_tokenizer");
        op.add(Builder::keyword, KeywordTokenizer._DESERIALIZER, "keyword");
        op.add(Builder::kuromojiTokenizer, KuromojiTokenizer._DESERIALIZER, "kuromoji_tokenizer");
        op.add(Builder::letter, LetterTokenizer._DESERIALIZER, "letter");
        op.add(Builder::lowercase, LowercaseTokenizer._DESERIALIZER, "lowercase");
        op.add(Builder::ngram, NGramTokenizer._DESERIALIZER, "ngram");
        op.add(Builder::noriTokenizer, NoriTokenizer._DESERIALIZER, "nori_tokenizer");
        op.add(Builder::pathHierarchy, PathHierarchyTokenizer._DESERIALIZER, "path_hierarchy");
        op.add(Builder::pattern, PatternTokenizer._DESERIALIZER, "pattern");
        op.add(Builder::standard, StandardTokenizer._DESERIALIZER, "standard");
        op.add(Builder::uaxUrlEmail, UaxEmailUrlTokenizer._DESERIALIZER, "uax_url_email");
        op.add(Builder::whitespace, WhitespaceTokenizer._DESERIALIZER, "whitespace");
        op.setTypeProperty("type", null);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TokenizerDefinition> {
        private Kind _kind;
        private TokenizerDefinitionVariant _value;

        public ObjectBuilder<TokenizerDefinition> charGroup(CharGroupTokenizer v) {
            this._kind = Kind.CharGroup;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> charGroup(Function<CharGroupTokenizer.Builder, ObjectBuilder<CharGroupTokenizer>> fn) {
            return this.charGroup(fn.apply(new CharGroupTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> edgeNgram(EdgeNGramTokenizer v) {
            this._kind = Kind.EdgeNgram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> edgeNgram(Function<EdgeNGramTokenizer.Builder, ObjectBuilder<EdgeNGramTokenizer>> fn) {
            return this.edgeNgram(fn.apply(new EdgeNGramTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> icuTokenizer(IcuTokenizer v) {
            this._kind = Kind.IcuTokenizer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> icuTokenizer(Function<IcuTokenizer.Builder, ObjectBuilder<IcuTokenizer>> fn) {
            return this.icuTokenizer(fn.apply(new IcuTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> keyword(KeywordTokenizer v) {
            this._kind = Kind.Keyword;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> keyword(Function<KeywordTokenizer.Builder, ObjectBuilder<KeywordTokenizer>> fn) {
            return this.keyword(fn.apply(new KeywordTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> kuromojiTokenizer(KuromojiTokenizer v) {
            this._kind = Kind.KuromojiTokenizer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> kuromojiTokenizer(Function<KuromojiTokenizer.Builder, ObjectBuilder<KuromojiTokenizer>> fn) {
            return this.kuromojiTokenizer(fn.apply(new KuromojiTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> letter(LetterTokenizer v) {
            this._kind = Kind.Letter;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> letter(Function<LetterTokenizer.Builder, ObjectBuilder<LetterTokenizer>> fn) {
            return this.letter(fn.apply(new LetterTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> lowercase(LowercaseTokenizer v) {
            this._kind = Kind.Lowercase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> lowercase(Function<LowercaseTokenizer.Builder, ObjectBuilder<LowercaseTokenizer>> fn) {
            return this.lowercase(fn.apply(new LowercaseTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> ngram(NGramTokenizer v) {
            this._kind = Kind.Ngram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> ngram(Function<NGramTokenizer.Builder, ObjectBuilder<NGramTokenizer>> fn) {
            return this.ngram(fn.apply(new NGramTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> noriTokenizer(NoriTokenizer v) {
            this._kind = Kind.NoriTokenizer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> noriTokenizer(Function<NoriTokenizer.Builder, ObjectBuilder<NoriTokenizer>> fn) {
            return this.noriTokenizer(fn.apply(new NoriTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> pathHierarchy(PathHierarchyTokenizer v) {
            this._kind = Kind.PathHierarchy;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> pathHierarchy(Function<PathHierarchyTokenizer.Builder, ObjectBuilder<PathHierarchyTokenizer>> fn) {
            return this.pathHierarchy(fn.apply(new PathHierarchyTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> pattern(PatternTokenizer v) {
            this._kind = Kind.Pattern;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> pattern(Function<PatternTokenizer.Builder, ObjectBuilder<PatternTokenizer>> fn) {
            return this.pattern(fn.apply(new PatternTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> standard(StandardTokenizer v) {
            this._kind = Kind.Standard;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> standard(Function<StandardTokenizer.Builder, ObjectBuilder<StandardTokenizer>> fn) {
            return this.standard(fn.apply(new StandardTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> uaxUrlEmail(UaxEmailUrlTokenizer v) {
            this._kind = Kind.UaxUrlEmail;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> uaxUrlEmail(Function<UaxEmailUrlTokenizer.Builder, ObjectBuilder<UaxEmailUrlTokenizer>> fn) {
            return this.uaxUrlEmail(fn.apply(new UaxEmailUrlTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenizerDefinition> whitespace(WhitespaceTokenizer v) {
            this._kind = Kind.Whitespace;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizerDefinition> whitespace(Function<WhitespaceTokenizer.Builder, ObjectBuilder<WhitespaceTokenizer>> fn) {
            return this.whitespace(fn.apply(new WhitespaceTokenizer.Builder()).build());
        }

        @Override
        public TokenizerDefinition build() {
            this._checkSingleUse();
            return new TokenizerDefinition(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        CharGroup("char_group"),
        EdgeNgram("edge_ngram"),
        IcuTokenizer("icu_tokenizer"),
        Keyword("keyword"),
        KuromojiTokenizer("kuromoji_tokenizer"),
        Letter("letter"),
        Lowercase("lowercase"),
        Ngram("ngram"),
        NoriTokenizer("nori_tokenizer"),
        PathHierarchy("path_hierarchy"),
        Pattern("pattern"),
        Standard("standard"),
        UaxUrlEmail("uax_url_email"),
        Whitespace("whitespace");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

